/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFactory;
import org.eclipse.apogy.core.environment.earth.orbit.Corridor;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitModel;
import org.eclipse.apogy.core.environment.earth.orbit.impl.SpacecraftSwathCorridorImpl;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Transform;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftSwathCorridorCustomImpl
extends SpacecraftSwathCorridorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftSwathCorridorImpl.class);
    protected static final Date START_TIME_EDEFAULT = null;

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return false;
    }

    @Override
    public void update() {
        try {
            EarthOrbitModel earthOrbitModel = (EarthOrbitModel)this.getOrbitModel();
            Propagator propagator = earthOrbitModel.getOreKitPropagator();
            Corridor corridor = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createCorridor();
            CorridorHandler corridorHandler = new CorridorHandler(this.leftSwathAngle, this.rightSwathAngle);
            propagator.setMasterMode(this.getTimeInterval(), (OrekitFixedStepHandler)corridorHandler);
            AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(this.getStartTime());
            AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createAbsoluteDate(this.getEndTime());
            try {
                propagator.propagate(startAbsoluteDate, endAbsoluteDate);
                for (CorridorPoint point : corridorHandler.getCorridor()) {
                    AbsoluteDate absoluteDate = point.getDate();
                    Date date = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createDate(absoluteDate);
                    GeodeticPoint left = point.getLeft();
                    GeographicCoordinates leftCoord = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(left.getLongitude(), left.getLatitude(), left.getAltitude());
                    GeodeticPoint center = point.getCenter();
                    GeographicCoordinates centerCoord = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(center.getLongitude(), center.getLatitude(), center.getAltitude());
                    GeodeticPoint right = point.getRight();
                    GeographicCoordinates rightCoord = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(right.getLongitude(), right.getLatitude(), right.getAltitude());
                    org.eclipse.apogy.core.environment.earth.orbit.CorridorPoint newPoint = ApogyCoreEnvironmentEarthOrbitFactory.eINSTANCE.createCorridorPoint();
                    newPoint.setTime(date);
                    newPoint.setLeft(leftCoord);
                    newPoint.setCenter(centerCoord);
                    newPoint.setRight(rightCoord);
                    corridor.getPoints().add((Object)newPoint);
                }
                this.setCorridor(corridor);
            }
            catch (PropagationException e1) {
                e1.printStackTrace();
                Logger.error("Error occured during execution.", (Throwable)e1);
                throw e1;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.error(t.getMessage(), t);
        }
    }

    private static class CorridorHandler
    implements OrekitFixedStepHandler {
        private double leftSwathAngle = 0.0;
        private double rightSwathAngle = 0.0;
        private final BodyShape earth;
        private final List<CorridorPoint> corridor;

        public CorridorHandler(double leftSwathAngle, double rightSwathAngle) throws OrekitException {
            this.leftSwathAngle = leftSwathAngle;
            this.rightSwathAngle = rightSwathAngle;
            this.earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
            this.corridor = new ArrayList<CorridorPoint>();
        }

        public void init(SpacecraftState arg0, AbsoluteDate absoluteDate) throws PropagationException {
        }

        public void handleStep(SpacecraftState currentState, boolean isLast) throws PropagationException {
            try {
                AbsoluteDate date = currentState.getDate();
                TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
                Transform t = currentState.getFrame().getTransformTo(this.earth.getBodyFrame(), date);
                Vector3D p = t.transformPosition(pvInert.getPosition());
                Vector3D v = t.transformVector(pvInert.getVelocity());
                Vector3D nadir = p.normalize().negate();
                Line centerLine = new Line(p, new Vector3D(0.0, 0.0, 0.0));
                GeodeticPoint centerPoint = this.earth.getIntersectionPoint(centerLine, p, this.earth.getBodyFrame(), date);
                Vector3D crossTrack = p.crossProduct((Vector)v).normalize();
                double r = p.getNorm();
                double deltaR = Math.cos(this.leftSwathAngle) * r;
                double deltaC = Math.sin(this.leftSwathAngle) * r;
                Line leftLine = new Line(p, new Vector3D(1.0, p, deltaR, nadir, deltaC, crossTrack));
                GeodeticPoint left = this.earth.getIntersectionPoint(leftLine, p, this.earth.getBodyFrame(), date);
                deltaR = Math.cos(this.rightSwathAngle) * r;
                deltaC = Math.sin(this.rightSwathAngle) * r;
                Line rightLine = new Line(p, new Vector3D(1.0, p, deltaR, nadir, -deltaC, crossTrack));
                GeodeticPoint right = this.earth.getIntersectionPoint(rightLine, p, this.earth.getBodyFrame(), date);
                this.corridor.add(new CorridorPoint(date, left, centerPoint, right));
            }
            catch (OrekitException oe) {
                throw new PropagationException(oe);
            }
        }

        public List<CorridorPoint> getCorridor() {
            return this.corridor;
        }
    }

    private static class CorridorPoint {
        private final AbsoluteDate date;
        private final GeodeticPoint left;
        private final GeodeticPoint center;
        private final GeodeticPoint right;

        public CorridorPoint(AbsoluteDate date, GeodeticPoint left, GeodeticPoint center, GeodeticPoint right) {
            this.date = date;
            this.left = left;
            this.center = center;
            this.right = right;
        }

        public AbsoluteDate getDate() {
            return this.date;
        }

        public GeodeticPoint getLeft() {
            return this.left;
        }

        public GeodeticPoint getCenter() {
            return this.center;
        }

        public GeodeticPoint getRight() {
            return this.right;
        }
    }
}

