/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.parts;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.common.e4.ui.ApogyCommonE4UIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.composites.EarthViewConfigurationComposite;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class EarthViewConfigurationPart
extends AbstractSessionPart<EarthViewConfiguration> {
    private EarthViewConfigurationComposite composite;
    protected String partName = "Earth View Configuration";
    @Inject
    MPart mPart;
    @Inject
    public ESelectionService selectionService;

    protected void createComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionTitle("Earth View Layer Details");
        settings.setCollectionSectionTitle("Earth View Layers");
        this.composite = new EarthViewConfigurationComposite(parent, 2048, settings){

            @Override
            protected void selectionChanged(IStructuredSelection selection) {
                List items = this.getSelectedItemObjects();
                AbstractWorldWindLayer item = items.isEmpty() ? null : (AbstractWorldWindLayer)items.get(0);
                EarthViewConfigurationPart.this.selectionService.setSelection((Object)item);
            }
        };
    }

    protected void doSetContent(EarthViewConfiguration configuration) {
        this.composite.setRootEObject(configuration);
        String newName = this.partName;
        if (configuration != null) {
            newName = String.valueOf(newName) + " - " + configuration.getName();
        }
        this.mPart.setLabel(newName);
    }

    @Inject
    @Optional
    public void setSelection(@Named(value="org.eclipse.ui.selection") EarthViewConfiguration earthViewConfiguration) {
        if (ApogyCommonE4UIFacade.INSTANCE.isActive(this.ePartService, "org.eclipse.apogy.core.environment.earth.ui.earthview") && earthViewConfiguration != null) {
            this.setContent((EObject)earthViewConfiguration);
        }
    }
}

