/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayerPresentation;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.RectangularRegionProvider;
import org.eclipse.apogy.core.environment.surface.SurfaceWorksite;
import org.eclipse.apogy.core.environment.surface.ui.MapAnnotation;
import org.eclipse.apogy.core.environment.surface.ui.MapViewConfiguration;
import org.eclipse.apogy.core.environment.surface.ui.MapViewConfigurationList;
import org.eclipse.apogy.core.environment.surface.ui.impl.ApogySurfaceEnvironmentUIFacadeImpl;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ToolsList;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySurfaceEnvironmentUIFacadeCustomImpl
extends ApogySurfaceEnvironmentUIFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySurfaceEnvironmentUIFacadeImpl.class);

    @Override
    public List<RectangularRegionProvider> getVisibleRectangularRegionProvider(MapViewConfiguration mapViewConfiguration) {
        ArrayList<RectangularRegionProvider> results = new ArrayList<RectangularRegionProvider>();
        for (MapAnnotation annotation : mapViewConfiguration.getMapAnnotations()) {
            if (!annotation.isVisible() || !(annotation instanceof RectangularRegionProvider)) continue;
            results.add((RectangularRegionProvider)annotation);
        }
        for (ImageMapLayerPresentation imlp : mapViewConfiguration.getMapLayers()) {
            if (!imlp.isVisible() || !(imlp instanceof RectangularRegionProvider)) continue;
            results.add((RectangularRegionProvider)imlp);
        }
        return results;
    }

    @Override
    public AbstractEImage getImageMapLayerPresentationImage(MapViewConfiguration mapViewConfiguration, RectangularRegion mapViewExtent, int maximumImageSizePixels) {
        AbstractEImage result = null;
        AbstractEImage mapImage = mapViewConfiguration.getMapImage();
        double horizontalResolution = (double)mapImage.getWidth() / mapViewConfiguration.getMapImageRectangularRegion().getXDimension();
        double verticalResolution = (double)mapImage.getHeight() / mapViewConfiguration.getMapImageRectangularRegion().getYDimension();
        if (ApogySurfaceEnvironmentFacade.INSTANCE.fitsInside(mapViewExtent, mapViewConfiguration.getMapImageRectangularRegion())) {
            double minX = mapViewExtent.getXMin();
            double maxX = mapViewExtent.getXMax();
            double minY = mapViewExtent.getYMin();
            double maxY = mapViewExtent.getYMax();
            int x = (int)Math.round((minX - mapViewConfiguration.getMapImageRectangularRegion().getXMin()) * horizontalResolution);
            int y = mapImage.getHeight() - (int)Math.round((maxY - mapViewConfiguration.getMapImageRectangularRegion().getYMin()) * verticalResolution);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            int width = (int)Math.round((maxX - minX) * horizontalResolution);
            int height = (int)Math.round((maxY - minY) * verticalResolution);
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            try {
                result = EImagesUtilities.INSTANCE.getSubImage(mapImage, x, y, width, height);
                if (width * height > maximumImageSizePixels) {
                    double scaleFactor = Math.sqrt((double)maximumImageSizePixels / (double)(mapImage.getWidth() * mapImage.getHeight()));
                    result = EImagesUtilities.INSTANCE.resize(result, scaleFactor);
                }
            }
            catch (Throwable t) {
                Logger.error("getImageMapLayerPresentationImage() failed!", t);
            }
        } else {
            int resultWidth = (int)Math.round(horizontalResolution * mapViewExtent.getXDimension());
            int resultHeight = (int)Math.round(verticalResolution * mapViewExtent.getYDimension());
            if (resultWidth <= 0) {
                resultWidth = 1;
            }
            if (resultHeight <= 0) {
                resultHeight = 1;
            }
            double scaleFactor = 1.0;
            if (resultWidth * resultHeight > maximumImageSizePixels) {
                scaleFactor = Math.sqrt((double)maximumImageSizePixels / (double)(resultWidth * resultHeight));
                resultWidth = (int)Math.floor(scaleFactor * (double)resultWidth);
                resultHeight = (int)Math.floor(scaleFactor * (double)resultHeight);
                mapImage = EImagesUtilities.INSTANCE.resize(mapImage, scaleFactor);
            }
            int red = mapViewConfiguration.getBackgroundColor().rgb.red;
            int green = mapViewConfiguration.getBackgroundColor().rgb.green;
            int blue = mapViewConfiguration.getBackgroundColor().rgb.blue;
            result = EImagesUtilities.INSTANCE.createUniformColorImage(resultWidth, resultHeight, red, green, blue, 255);
            double xTranslation = mapViewConfiguration.getMapImageRectangularRegion().getXMin() - mapViewExtent.getXMin();
            int widthTranslation = (int)Math.round(xTranslation * horizontalResolution * scaleFactor);
            double yTranslation = mapViewExtent.getYMax() - mapViewConfiguration.getMapImageRectangularRegion().getYMax();
            int heightTranslation = (int)Math.round(yTranslation * verticalResolution * scaleFactor);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(widthTranslation, heightTranslation);
            Graphics2D g = result.asBufferedImage().createGraphics();
            g.drawImage(mapImage.asBufferedImage(), affineTransform, null);
            g.dispose();
        }
        return result;
    }

    @Override
    public String getMapViewConfigurationIdentifier(MapViewConfiguration mapViewConfiguration) {
        String identifier = null;
        if (mapViewConfiguration != null) {
            identifier = ApogyCommonEMFFacade.INSTANCE.getID((EObject)mapViewConfiguration);
        }
        return identifier;
    }

    @Override
    public MapViewConfiguration getActiveMapViewConfiguration(String identifier) {
        MapViewConfigurationList mapViewConfigurationList;
        MapViewConfiguration mapViewConfiguration = null;
        if (identifier != null && (mapViewConfigurationList = this.getActiveMapViewConfigurationList()) != null) {
            Iterator it = mapViewConfigurationList.getMapViewConfigurations().iterator();
            while (mapViewConfiguration == null && it.hasNext()) {
                MapViewConfiguration next = (MapViewConfiguration)it.next();
                if (this.getMapViewConfigurationIdentifier(next).compareTo(identifier) != 0) continue;
                mapViewConfiguration = next;
            }
        }
        return mapViewConfiguration;
    }

    @Override
    public MapViewConfigurationList getActiveMapViewConfigurationList() {
        ToolsList toolsList;
        MapViewConfigurationList mapViewConfigurationList = null;
        InvocatorSession session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (session != null && (toolsList = session.getToolsList()) != null) {
            Iterator it = toolsList.getToolsListContainers().iterator();
            while (mapViewConfigurationList == null && it.hasNext()) {
                AbstractToolsListContainer abstractToolsListContainer = (AbstractToolsListContainer)it.next();
                if (!(abstractToolsListContainer instanceof MapViewConfigurationList)) continue;
                mapViewConfigurationList = (MapViewConfigurationList)abstractToolsListContainer;
            }
        }
        return mapViewConfigurationList;
    }

    @Override
    public List<FeatureOfInterestList> getFeatureOfInterestLists(InvocatorSession session) {
        ApogyEnvironment se;
        ArrayList<FeatureOfInterestList> featureOfInterestLists = new ArrayList<FeatureOfInterestList>();
        if (session != null && session.getEnvironment() instanceof ApogyEnvironment && (se = (ApogyEnvironment)session.getEnvironment()).getActiveWorksite() instanceof SurfaceWorksite) {
            SurfaceWorksite surfaceWorksite = (SurfaceWorksite)se.getActiveWorksite();
            for (Map map : surfaceWorksite.getMapsList().getMaps()) {
                for (AbstractMapLayer layer : map.getLayers()) {
                    if (!(layer instanceof FeaturesOfInterestMapLayer)) continue;
                    FeaturesOfInterestMapLayer featuresOfInterestMapLayer = (FeaturesOfInterestMapLayer)layer;
                    featureOfInterestLists.add(featuresOfInterestMapLayer.getFeatures());
                }
            }
        }
        return featureOfInterestLists;
    }
}

