/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.impl.EllipseShapeImageLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGB;

public class EllipseShapeImageLayerCustomImpl
extends EllipseShapeImageLayerImpl {
    @Override
    public void dispose() {
    }

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        RectangularRegion rectangularRegion = this.getImageMapLayerRegion();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__WIDTH, (Object)rectangularRegion.getXDimension());
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__HEIGHT, (Object)rectangularRegion.getYDimension());
        int width = (int)Math.round(rectangularRegion.getXDimension() / this.getRequiredResolution());
        int height = (int)Math.round(rectangularRegion.getYDimension() / this.getRequiredResolution());
        BufferedImage bufferedImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height).asBufferedImage();
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(this.getDrawingColor());
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, width - 1, height - 1);
        g2d.draw(ellipse);
        if (this.isShowCenterLines()) {
            if (Math.IEEEremainder(width, 2.0) == 0.0) {
                int x1 = (int)Math.floor((float)width * 0.5f);
                int x2 = x1 - 1;
                g2d.drawLine(x1, 0, x1, height);
                g2d.drawLine(x2, 0, x2, height);
            } else {
                int xCenter = (int)Math.floor((float)width * 0.5f);
                g2d.drawLine(xCenter, 0, xCenter, height);
            }
            if (Math.IEEEremainder(height, 2.0) == 0.0) {
                int y1 = Math.round((float)height * 0.5f);
                int y2 = y1 - 1;
                g2d.drawLine(0, y1, width, y1);
                g2d.drawLine(0, y2, width, y2);
            } else {
                int yCenter = (int)Math.floor((float)height * 0.5f);
                g2d.drawLine(0, yCenter, width, yCenter);
            }
        }
        if (this.isShapedFilled()) {
            g2d.fill(ellipse);
        }
        g2d.dispose();
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        eImage.setImageContent(bufferedImage);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)eImage, true);
    }

    @Override
    public RectangularRegion getImageMapLayerRegion() {
        RectangularRegion rectangularRegion = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularRegion();
        rectangularRegion.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
        if (this.getMap() != null && this.getMap().getTransformation() != null) {
            Matrix4d m = this.getMap().getTransformation().asMatrix4d();
            Matrix4d translation = new Matrix4d();
            translation.setIdentity();
            translation.set(new Vector3d(-this.getEllipseWidth() / 2.0, -this.getEllipseHeight() / 2.0, 0.0));
            m.mul(translation);
            Matrix4x4 transform = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
            rectangularRegion.setTransformation(transform);
        }
        rectangularRegion.setXMin(-this.getEllipseWidth() / 2.0);
        rectangularRegion.setXMax(this.getEllipseWidth() / 2.0);
        rectangularRegion.setYMin(-this.getEllipseHeight() / 2.0);
        rectangularRegion.setYMax(this.getEllipseHeight() / 2.0);
        return rectangularRegion;
    }

    protected Color getDrawingColor() {
        if (this.getColor() != null) {
            if (this.getColor().alpha != 0) {
                RGB rgb = this.getColor().rgb;
                return new Color((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f);
            }
            return null;
        }
        return null;
    }
}

