/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.impl.PolygonShapeImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.RGB;

public abstract class PolygonShapeImageMapLayerCustomImpl
extends PolygonShapeImageMapLayerImpl {
    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        ArrayList<Tuple3d> vertices = new ArrayList<Tuple3d>();
        vertices.addAll(this.getVertices());
        RectangularRegion rectangularRegion = this.getImageMapLayerRegion();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__WIDTH, (Object)rectangularRegion.getXDimension());
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__HEIGHT, (Object)rectangularRegion.getYDimension());
        int width = (int)Math.round(rectangularRegion.getXDimension() / this.getRequiredResolution());
        int height = (int)Math.round(rectangularRegion.getYDimension() / this.getRequiredResolution());
        BufferedImage bufferedImage = EImagesUtilities.INSTANCE.createTransparentImage(width, height).asBufferedImage();
        List<Point> points = this.convertToImageFrame(vertices, rectangularRegion, width, height);
        Polygon polygon = this.createPolygon(points);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setColor(this.getDrawingColor());
        g2d.draw(polygon);
        if (this.isShapedFilled()) {
            g2d.fill(polygon);
        }
        g2d.dispose();
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        eImage.setImageContent(bufferedImage);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)eImage, true);
    }

    @Override
    public RectangularRegion getImageMapLayerRegion() {
        return this.getRectangularRegion(this.getVertices());
    }

    protected Color getDrawingColor() {
        if (this.getColor() != null) {
            if (this.getColor().alpha != 0) {
                RGB rgb = this.getColor().rgb;
                return new Color((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f);
            }
            return null;
        }
        return null;
    }

    protected RectangularRegion getRectangularRegion(List<Tuple3d> vertices) {
        RectangularRegion rectangularRegion = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularRegion();
        rectangularRegion.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
        if (vertices.size() > 0) {
            double xMin = Double.POSITIVE_INFINITY;
            double xMax = Double.NEGATIVE_INFINITY;
            double yMin = Double.POSITIVE_INFINITY;
            double yMax = Double.NEGATIVE_INFINITY;
            for (Tuple3d vertex : vertices) {
                if (vertex.getX() < xMin) {
                    xMin = vertex.getX();
                }
                if (vertex.getX() > xMax) {
                    xMax = vertex.getX();
                }
                if (vertex.getY() < yMin) {
                    yMin = vertex.getY();
                }
                if (!(vertex.getY() > yMax)) continue;
                yMax = vertex.getY();
            }
            rectangularRegion.setXMin(xMin);
            rectangularRegion.setXMax(xMax);
            rectangularRegion.setYMin(yMin);
            rectangularRegion.setYMax(yMax);
            Matrix4d matrix = new Matrix4d();
            matrix.setIdentity();
            matrix.setTranslation(new Vector3d(xMin, yMin, 0.0));
            rectangularRegion.setTransformation(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix));
        }
        return rectangularRegion;
    }

    protected List<Point> convertToImageFrame(List<Tuple3d> vertices, RectangularRegion rectangularRegion, int imageWidth, int imageHeight) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Tuple3d vertex : vertices) {
            int y;
            int x = (int)Math.round((vertex.getX() - rectangularRegion.getXMin()) / rectangularRegion.getXDimension() * (double)imageWidth);
            if (x >= imageWidth) {
                x = imageWidth - 1;
            }
            if (x < 0) {
                x = 0;
            }
            if ((y = (int)Math.round((rectangularRegion.getYMax() - vertex.getY()) / rectangularRegion.getYDimension() * (double)imageHeight)) >= imageHeight) {
                y = imageHeight - 1;
            }
            if (y < 0) {
                y = 0;
            }
            Point point = new Point(x, y);
            points.add(point);
        }
        return points;
    }

    protected Polygon createPolygon(List<Point> points) {
        Polygon polygon = new Polygon();
        if (points.size() > 0) {
            for (Point point : points) {
                polygon.addPoint(point.x, point.y);
            }
        }
        return polygon;
    }
}

