/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.AbstractTimeSource;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.CurrentTimeSource;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ConnectionPoint;
import org.eclipse.apogy.core.ConnectionPointsList;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.EquatorialCoordinates;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.Sun;
import org.eclipse.apogy.core.environment.TimeSourcesList;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.WorksiteNode;
import org.eclipse.apogy.core.environment.WorksitesList;
import org.eclipse.apogy.core.environment.impl.ApogyCoreEnvironmentFacadeImpl;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.DataProductsList;
import org.eclipse.apogy.core.invocator.DataProductsListsContainer;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.OperationCallResultsList;
import org.eclipse.apogy.core.invocator.ToolsList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreEnvironmentFacadeCustomImpl
extends ApogyCoreEnvironmentFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreEnvironmentFacadeImpl.class);
    private Adapter activeSessionAdapter = null;
    private Adapter activeApogyEnvironmentAdapter = null;
    private Adapter activeWorksiteAdapter = null;

    protected ApogyCoreEnvironmentFacadeCustomImpl() {
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getActiveSessionAdapter());
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() != null) {
            this.updateEnvironment(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment());
        }
    }

    @Override
    public void setActiveApogyEnvironment(ApogyEnvironment newActiveApogyEnvironment) {
        if (this.getActiveApogyEnvironment() != null) {
            this.getActiveApogyEnvironment().eAdapters().remove((Object)this.getApogyEnvironmentAdapter());
        }
        if (newActiveApogyEnvironment != null) {
            newActiveApogyEnvironment.eAdapters().add((Object)this.getApogyEnvironmentAdapter());
        }
        super.setActiveApogyEnvironment(newActiveApogyEnvironment);
    }

    @Override
    public InvocatorSession createApogySession() {
        return this.createApogySession(true, true, true, true);
    }

    @Override
    public InvocatorSession createApogySession(boolean createEnvironment, boolean createPrograms, boolean createDataProducts, boolean createTools) {
        InvocatorSession session = ApogyCoreInvocatorFactory.eINSTANCE.createInvocatorSession();
        Context context = null;
        if (createEnvironment) {
            ApogyEnvironment environment = ApogyCoreEnvironmentFactory.eINSTANCE.createApogyEnvironment();
            environment.setLocalTypesList(ApogyCoreInvocatorFactory.eINSTANCE.createLocalTypesList());
            environment.setVariablesList(ApogyCoreInvocatorFactory.eINSTANCE.createVariablesList());
            environment.setContextsList(ApogyCoreInvocatorFactory.eINSTANCE.createContextsList());
            context = ApogyCoreInvocatorFactory.eINSTANCE.createContext();
            context.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)environment.getContextsList(), (EObject)context, (ETypedElement)ApogyCoreInvocatorPackage.Literals.CONTEXTS_LIST__CONTEXTS));
            context.setVariableImplementationsList(ApogyCoreInvocatorFactory.eINSTANCE.createVariableImplementationsList());
            environment.getContextsList().getContexts().add((Object)context);
            environment.setActiveContext(context);
            WorksitesList worksitesList = ApogyCoreEnvironmentFactory.eINSTANCE.createWorksitesList();
            environment.setWorksitesList(worksitesList);
            TimeSourcesList timeSourcesList = ApogyCoreEnvironmentFactory.eINSTANCE.createTimeSourcesList();
            timeSourcesList.getTimeSources().addAll(this.getAllAvaibleTimeSource());
            environment.setTimeSourcesList(timeSourcesList);
            environment.setActiveTimeSource((AbstractTimeSource)this.getCurrentTimeSource((Collection<AbstractTimeSource>)timeSourcesList.getTimeSources()));
            session.setEnvironment((Environment)environment);
        }
        if (createPrograms) {
            session.setProgramsList(ApogyCoreInvocatorFactory.eINSTANCE.createProgramsList());
            session.setProgramRuntimesList(ApogyCoreInvocatorFactory.eINSTANCE.createProgramRuntimesList());
        }
        if (createDataProducts) {
            DataProductsListsContainer listsContainer = ApogyCoreInvocatorFactory.eINSTANCE.createDataProductsListsContainer();
            DataProductsList dataProductsList = ApogyCoreInvocatorFactory.eINSTANCE.createDataProductsList();
            dataProductsList.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)listsContainer, (EObject)dataProductsList, (ETypedElement)ApogyCoreInvocatorPackage.Literals.DATA_PRODUCTS_LISTS_CONTAINER__DATA_PRODUCTS_LIST));
            listsContainer.getDataProductsList().add((Object)dataProductsList);
            session.setDataProductsListContainer(listsContainer);
            OperationCallResultsList operationCallResultsList = ApogyCoreInvocatorFactory.eINSTANCE.createOperationCallResultsList();
            operationCallResultsList.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)dataProductsList, (EObject)operationCallResultsList, (ETypedElement)ApogyCoreInvocatorPackage.Literals.DATA_PRODUCTS_LIST__OPERATION_CALL_RESULTS_LIST));
            dataProductsList.setOperationCallResultsList(operationCallResultsList);
            if (context != null) {
                context.setDataProductsList(dataProductsList);
            }
        }
        if (createTools) {
            ToolsList toolsList = ApogyCoreInvocatorFactory.eINSTANCE.createToolsList();
            session.setToolsList(toolsList);
        }
        return session;
    }

    @Override
    public StarField createAndInitializeStars() {
        StarField starField = ApogyCoreEnvironmentFactory.eINSTANCE.createStarField();
        starField.setDescription("Star Field.");
        starField.setStarFieldFileName("bright_star_catalog_5.txt");
        starField.setNodeId("STAR FIELD");
        return starField;
    }

    @Override
    public SortedSet<Star> sortByMagnitude(List<Star> stars) {
        TreeSet<Star> treeSet = new TreeSet<Star>(new StarMagnitudeComparator());
        treeSet.addAll(stars);
        return treeSet;
    }

    @Override
    public Sky createSky() {
        Sky sky = ApogyCoreEnvironmentFactory.eINSTANCE.createSky();
        return sky;
    }

    @Override
    public SkyNode createSkyNode() {
        SkyNode skyNode = ApogyCoreEnvironmentFactory.eINSTANCE.createSkyNode();
        this.initializeSkyNode(skyNode);
        return skyNode;
    }

    @Override
    public void initializeSkyNode(SkyNode skyNode) {
        skyNode.setDescription("Sky");
        skyNode.setNodeId("SKY");
        Sun sun = ApogyCoreEnvironmentFactory.eINSTANCE.createSun();
        sun.setDescription("The Sun.");
        sun.setNodeId("SUN");
        Point3d sunPosition = new Point3d();
        TransformNode sunTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(sunPosition.x, sunPosition.y, sunPosition.z, 0.0, 0.0, 0.0);
        sunTransformNode.setDescription("Transform attaching the Sun to the Sky.");
        sunTransformNode.setNodeId("SUN_TRANSFORM");
        skyNode.getChildren().add((Object)sunTransformNode);
        sunTransformNode.setParent((Node)skyNode);
        sunTransformNode.getChildren().add((Object)sun);
        try {
            StarField starField = this.createAndInitializeStars();
            TransformNode starFieldTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            starFieldTransformNode.setDescription("Transform attaching the Star Field to the Sky.");
            starFieldTransformNode.setNodeId("STAR_FIELD_TRANSFORM");
            skyNode.getChildren().add((Object)starFieldTransformNode);
            starFieldTransformNode.getChildren().add((Object)starField);
        }
        catch (Exception e) {
            Logger.error("initializeSkyNode(Sky, SkyNode): Could not initialize the StarField.", (Throwable)e);
        }
    }

    @Override
    public Star createStar(float magnitude, double rightAscension, double declination) {
        Star star = ApogyCoreEnvironmentFactory.eINSTANCE.createStar();
        star.setMagnitude(magnitude);
        EquatorialCoordinates equatorialCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
        equatorialCoordinates.setRightAscension(rightAscension);
        equatorialCoordinates.setDeclination(declination);
        equatorialCoordinates.setRadius(Double.MAX_VALUE);
        star.setEquatorialCoordinates(equatorialCoordinates);
        return star;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getVector(Node node, ApogySystem targetApogySystem, ConnectionPoint connectionPoint, Environment environment) {
        ApogyEnvironment apogyEnvironment;
        if (environment instanceof ApogyEnvironment && (apogyEnvironment = (ApogyEnvironment)environment).getActiveWorksite() instanceof Worksite) {
            Matrix4d matrix = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)connectionPoint.getNode(), node);
            Vector3d v = new Vector3d();
            matrix.get(v);
            v.normalize();
            return ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)v);
        }
        return null;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getVector(ApogySystem sourceApogySystem, String nodeID, ApogySystem targetApogySystem, ConnectionPoint connectionPoint, Environment environment) {
        EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeID, sourceApogySystem.getTopologyRoot().getOriginNode());
        if (!nodes.isEmpty()) {
            Node node = (Node)nodes.get(0);
            return this.getVector(node, targetApogySystem, connectionPoint, environment);
        }
        return null;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getVector(ApogySystem sourceApogySystem, String nodeID, ApogySystem targetApogySystem, String connectionPointName, Environment environment) {
        EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeID, sourceApogySystem.getTopologyRoot().getOriginNode());
        if (!nodes.isEmpty()) {
            Node node = (Node)nodes.get(0);
            ConnectionPoint connectionPoint = this.getConnectionPointByName(targetApogySystem.getConnectionPointsList(), connectionPointName);
            if (connectionPoint != null) {
                return this.getVector(node, targetApogySystem, connectionPoint, environment);
            }
            return null;
        }
        return null;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getVector(ApogySystem sourceApogySystem, String nodeID, String targetSystemfullyQualifiedName, String connectionPointName, Environment environment) {
        ApogySystem targetSystem = ApogyCoreFacade.INSTANCE.getApogySystem(environment, targetSystemfullyQualifiedName);
        return this.getVector(sourceApogySystem, nodeID, targetSystem, connectionPointName, environment);
    }

    @Override
    public List<FeatureOfInterest> getAllFeatureOfInterestInActiveSession() {
        ArrayList<FeatureOfInterest> fois = new ArrayList<FeatureOfInterest>();
        List<FeatureOfInterestList> foiLists = this.getAllFeatureOfInterestListInActiveSession();
        for (FeatureOfInterestList list : foiLists) {
            fois.addAll((Collection<FeatureOfInterest>)list.getFeaturesOfInterest());
        }
        return fois;
    }

    @Override
    public List<FeatureOfInterestList> getAllFeatureOfInterestListInActiveSession() {
        AbstractWorksite worksite;
        ArrayList<FeatureOfInterestList> foiLists = new ArrayList<FeatureOfInterestList>();
        ApogyEnvironment apogyEnvironment = this.getActiveApogyEnvironment();
        if (apogyEnvironment != null && (worksite = apogyEnvironment.getActiveWorksite()) != null) {
            List children = ApogyCommonEMFFacade.INSTANCE.getEObjectsByType((EObject)worksite, ApogyCorePackage.Literals.FEATURE_OF_INTEREST_LIST);
            for (EObject eObject : children) {
                if (!(eObject instanceof FeatureOfInterestList)) continue;
                foiLists.add((FeatureOfInterestList)eObject);
            }
        }
        return foiLists;
    }

    private ConnectionPoint getConnectionPointByName(ConnectionPointsList connectionPointsList, String connectionPointName) {
        if (connectionPointsList.getConnectionPoints() != null && !connectionPointsList.getConnectionPoints().isEmpty()) {
            ConnectionPoint connectionPoint = null;
            Iterator it = connectionPointsList.getConnectionPoints().iterator();
            while (it.hasNext() && connectionPoint == null) {
                ConnectionPoint next = (ConnectionPoint)it.next();
                if (next.getName().compareTo(connectionPointName) != 0) continue;
                connectionPoint = next;
            }
            return connectionPoint;
        }
        return null;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getSunVector(ApogySystem apogySystem, String nodeID) {
        EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByID(nodeID, apogySystem.getTopologyRoot().getOriginNode());
        if (!nodes.isEmpty()) {
            Node node = (Node)nodes.get(0);
            return this.getSunVector(node);
        }
        return null;
    }

    @Override
    public org.eclipse.apogy.common.math.Tuple3d getSunVector(Node node) {
        Worksite worksite;
        WorksiteNode root;
        Sun sun = this.getActiveSun();
        if (sun != null && this.getActiveWorksite() instanceof Worksite && (root = (worksite = (Worksite)this.getActiveWorksite()).getWorksiteNode()) != null) {
            Matrix4d matrix = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)sun, node);
            Vector3d v = new Vector3d();
            matrix.get(v);
            v.normalize();
            return ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)v);
        }
        return null;
    }

    private List<AbstractTimeSource> getAllAvaibleTimeSource() {
        ArrayList<AbstractTimeSource> timeSources = new ArrayList<AbstractTimeSource>();
        List timeSourceEClass = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(ApogyCommonEMFPackage.Literals.ABSTRACT_TIME_SOURCE);
        for (EClass eClass : timeSourceEClass) {
            try {
                EObject eObject = EcoreUtil.create((EClass)eClass);
                if (!(eObject instanceof AbstractTimeSource)) continue;
                AbstractTimeSource timeSource = (AbstractTimeSource)eObject;
                timeSource.setName(timeSource.eClass().getName());
                timeSources.add(timeSource);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return timeSources;
    }

    private CurrentTimeSource getCurrentTimeSource(Collection<AbstractTimeSource> timeSources) {
        CurrentTimeSource currentTimeSource = null;
        Iterator<AbstractTimeSource> it = timeSources.iterator();
        while (it.hasNext() && currentTimeSource == null) {
            AbstractTimeSource timeSource = it.next();
            if (!(timeSource instanceof CurrentTimeSource)) continue;
            currentTimeSource = (CurrentTimeSource)timeSource;
        }
        return currentTimeSource;
    }

    private Adapter getActiveSessionAdapter() {
        if (this.activeSessionAdapter == null) {
            this.activeSessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade && (featureID = msg.getFeatureID(ApogyCoreInvocatorFacade.class)) == 2) {
                        if (msg.getNewValue() instanceof InvocatorSession) {
                            InvocatorSession invocatorSession = (InvocatorSession)msg.getNewValue();
                            ApogyCoreEnvironmentFacadeCustomImpl.this.updateEnvironment(invocatorSession.getEnvironment());
                        } else {
                            ApogyCoreEnvironmentFacadeCustomImpl.this.updateEnvironment(null);
                        }
                    }
                }
            };
        }
        return this.activeSessionAdapter;
    }

    private void updateEnvironment(Environment environment) {
        if (this.getActiveApogyEnvironment() != null) {
            this.getActiveApogyEnvironment().eAdapters().remove((Object)this.getApogyEnvironmentAdapter());
        }
        if (environment instanceof ApogyEnvironment) {
            ApogyEnvironment apogyEnvironment = (ApogyEnvironment)environment;
            this.setActiveApogyEnvironment(apogyEnvironment);
            this.setActiveTimeSource(apogyEnvironment.getActiveTimeSource());
            apogyEnvironment.eAdapters().add((Object)this.getApogyEnvironmentAdapter());
            this.updateActiveWorksite(apogyEnvironment.getActiveWorksite());
        } else {
            this.setActiveTimeSource(null);
            this.setActiveApogyEnvironment(null);
        }
    }

    private Adapter getApogyEnvironmentAdapter() {
        if (this.activeApogyEnvironmentAdapter == null) {
            this.activeApogyEnvironmentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyEnvironment) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 9: {
                                AbstractWorksite newActiveWorksite = (AbstractWorksite)msg.getNewValue();
                                ApogyCoreEnvironmentFacadeCustomImpl.this.updateActiveWorksite(newActiveWorksite);
                                break;
                            }
                            case 11: {
                                AbstractTimeSource newTimeSource = (AbstractTimeSource)msg.getNewValue();
                                ApogyCoreEnvironmentFacadeCustomImpl.this.setActiveTimeSource(newTimeSource);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeApogyEnvironmentAdapter;
    }

    private void updateActiveWorksite(AbstractWorksite abstractWorksite) {
        if (this.getActiveWorksite() != null) {
            this.getActiveWorksite().eAdapters().remove((Object)this.getWorksiteAdapter());
        }
        this.setActiveWorksite(abstractWorksite);
        if (this.getActiveWorksite() != null) {
            this.getActiveWorksite().eAdapters().add((Object)this.getWorksiteAdapter());
        }
        if (abstractWorksite instanceof Worksite) {
            Worksite worksite = (Worksite)abstractWorksite;
            Sky sky = worksite.getSky();
            if (sky != null) {
                this.setActiveSun(sky.getSun());
            } else {
                this.setActiveSun(null);
            }
        } else {
            this.setActiveSun(null);
        }
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Worksite) {
                        int featureID = msg.getFeatureID(Worksite.class);
                        switch (featureID) {
                            case 5: {
                                if (msg.getNewValue() instanceof Sky) {
                                    Sky newSky = (Sky)msg.getNewValue();
                                    ApogyCoreEnvironmentFacadeCustomImpl.this.setActiveSun(newSky.getSun());
                                    break;
                                }
                                ApogyCoreEnvironmentFacadeCustomImpl.this.setActiveSun(null);
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeApogyEnvironmentAdapter;
    }

    private class StarMagnitudeComparator
    implements Comparator<Star> {
        private StarMagnitudeComparator() {
        }

        @Override
        public int compare(Star star1, Star star2) {
            if (star1.getMagnitude() < star2.getMagnitude()) {
                return 1;
            }
            if (star1.getMagnitude() > star2.getMagnitude()) {
                return -1;
            }
            if (star1.getEquatorialCoordinates().getRightAscension() > star2.getEquatorialCoordinates().getRightAscension()) {
                return 1;
            }
            if (star1.getEquatorialCoordinates().getRightAscension() < star2.getEquatorialCoordinates().getRightAscension()) {
                return -1;
            }
            if (star1.getEquatorialCoordinates().getDeclination() > star2.getEquatorialCoordinates().getDeclination()) {
                return 1;
            }
            return -1;
        }
    }
}

