/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.Activator;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.EnvironmentUtilities;
import org.eclipse.apogy.core.environment.EquatorialCoordinates;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.impl.StarFieldImpl;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarFieldCustomImpl
extends StarFieldImpl {
    private static final Logger Logger = LoggerFactory.getLogger(StarFieldImpl.class);
    public static final String NODE_ID = "STAR FIELD";
    private boolean starsAreDirty = true;

    @Override
    public EList<Star> getStars() {
        if (this.starsAreDirty) {
            try {
                super.getStars().clear();
                super.getStars().addAll(this.loadStars());
            }
            catch (Exception e) {
                Logger.error("Error occured while loading stars from file <" + this.getStarFieldFileName() + ">.", (Throwable)e);
            }
            this.starsAreDirty = false;
        }
        return super.getStars();
    }

    @Override
    public void setStarFieldFileName(String newStarFieldFileName) {
        this.starsAreDirty = true;
        super.setStarFieldFileName(newStarFieldFileName);
    }

    private List<Star> loadStars() throws Exception {
        ArrayList<Star> stars = new ArrayList<Star>();
        String content = this.readFile();
        String[] lines = content.split("\n");
        int i = 0;
        while (i < lines.length) {
            Star star = this.parseLine(lines[i]);
            if (star != null) {
                stars.add(star);
            }
            ++i;
        }
        String filePath = Activator.getDefault().getStarsCatalogURL(this.getStarFieldFileName()).getPath();
        Logger.info("Sucessfully loaded <" + stars.size() + "> stars from URL <" + filePath + ">.");
        return stars;
    }

    private String readFile() throws Exception {
        URL url = Activator.getDefault().getStarsCatalogURL(this.getStarFieldFileName());
        InputStream inputStream = url.openConnection().getInputStream();
        if (inputStream != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        return "";
    }

    private Star parseLine(String line) {
        Star star = null;
        try {
            String[] entries = line.trim().split(" ");
            float rightAscension = EnvironmentUtilities.INSTANCE.parseRightAscension(entries[1]);
            float declination = EnvironmentUtilities.INSTANCE.parseDegMinSec(entries[2]);
            float magnitude = Float.parseFloat(entries[6]);
            star = ApogyCoreEnvironmentFactory.eINSTANCE.createStar();
            EquatorialCoordinates equatorialCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createEquatorialCoordinates();
            equatorialCoordinates.setRightAscension(rightAscension);
            equatorialCoordinates.setDeclination(declination);
            star.setMagnitude(magnitude);
            star.setEquatorialCoordinates(equatorialCoordinates);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return star;
    }
}

