/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.text.DecimalFormat;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.edit.utils.ApogyCommonEMFEditUtilsFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsETreeComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Argument;
import org.eclipse.apogy.core.invocator.ArgumentsList;
import org.eclipse.apogy.core.invocator.EClassArgument;
import org.eclipse.apogy.core.invocator.EDataTypeArgument;
import org.eclipse.apogy.core.invocator.EEnumArgument;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class OperationCallArgumentsListComposite
extends EMFFormsETreeComposite<AbstractOperationCall, ArgumentsList, Argument> {
    private static final int NAME_COL_MIN_WIDTH = 200;
    private static final int VALUE_COL_MIN_WIDTH = 400;
    private static final int UNITS_COL_MIN_WIDTH = 150;
    private TreeViewerColumn valueColumn;

    public OperationCallArgumentsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.ABSTRACT_OPERATION_CALL__ARGUMENTS_LIST}), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS, settings);
        settings.setDetailSectionDisplayed(true);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn parameterColumn = new TreeViewerColumn(viewer, 0);
        parameterColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        parameterColumn.getColumn().setText("Parameter");
        parameterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof Argument ? ((Argument)element).getEParameter().getName() : element.getClass().getSimpleName();
            }

            public String getToolTipText(Object element) {
                return element instanceof Argument ? ((Argument)element).getEParameter().getName() : element.getClass().getName();
            }
        });
        this.valueColumn = new TreeViewerColumn(viewer, 0);
        this.valueColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)400);
        this.valueColumn.getColumn().setText("Value");
        this.valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String str = "";
                if (element instanceof Argument) {
                    if (element instanceof EDataTypeArgument) {
                        EDataTypeArgument argument = (EDataTypeArgument)element;
                        str = argument.getValue();
                        Double valueDouble = 0.0;
                        try {
                            valueDouble = Double.parseDouble(str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        EParameter param = argument.getEParameter();
                        Unit unit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)param);
                        if (unit != null) {
                            if (argument.getValue() == null) {
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)argument, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, (Object)"0.0");
                            }
                            EOperationEParametersFormatProviderParameters formatParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProviderParameters();
                            formatParams.setParam(param);
                            EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
                            unitsParams.setParam(param);
                            DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(param.getEOperation(), formatParams);
                            Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(param.getEOperation(), unitsParams);
                            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)param);
                            if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
                                valueDouble = nativeUnits.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
                            }
                            str = format.format(valueDouble);
                        }
                    } else if (element instanceof EEnumArgument) {
                        str = ((EEnumArgument)element).getEEnumLiteral().getLiteral();
                    }
                } else {
                    str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText(element);
                }
                return str;
            }
        });
        TreeViewerColumn unitsColumn = new TreeViewerColumn(viewer, 0);
        unitsColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        unitsColumn.getColumn().setText("Units");
        unitsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String str = "";
                if (element instanceof EDataTypeArgument) {
                    EDataTypeArgument argument = (EDataTypeArgument)element;
                    EParameter param = argument.getEParameter();
                    EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
                    unitsParams.setParam(param);
                    Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(param.getEOperation(), unitsParams);
                    str = displayUnits == null ? "" : displayUnits.toString();
                }
                return str;
            }
        });
    }

    protected void doNew() {
        EClassArgument argument = (EClassArgument)this.getSelectedItemObjects().get(0);
        EObjectWizard wizard = new EObjectWizard((EObject)argument, null, ApogyCoreInvocatorPackage.Literals.ECLASS_ARGUMENT__VALUE, (EClass)argument.getEParameter().getEType(), null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
    }

    protected void createNewButtonBindings(Button button) {
        super.createNewButtonBindings(button);
        IViewerObservableValue treeViewerSingleSelectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ISWTObservableValue buttonEnabledObserveValue = WidgetProperties.enabled().observe((Widget)button);
        this.getDataBindingContext().bindValue((IObservableValue)buttonEnabledObserveValue, (IObservableValue)treeViewerSingleSelectionObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof EClassArgument && ((EClassArgument)fromObject).getValue() == null) {
                    return true;
                }
                if (fromObject instanceof EObject && !ApogyCommonEMFFacade.INSTANCE.getSettableEReferences((EObject)fromObject).isEmpty()) {
                    return true;
                }
                return false;
            }
        }));
    }

    protected void createDeleteButtonBindings(Button button) {
        super.createDeleteButtonBindings(button);
        IViewerObservableValue treeViewerSingleSelectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ISWTObservableValue btnDeleteEnabledObserveValue = WidgetProperties.enabled().observe((Widget)button);
        this.getDataBindingContext().bindValue((IObservableValue)btnDeleteEnabledObserveValue, (IObservableValue)treeViewerSingleSelectionObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(EObject.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject == OperationCallArgumentsListComposite.this.getRootEObject()) {
                    return false;
                }
                if (((AbstractOperationCall)OperationCallArgumentsListComposite.this.getRootEObject()).getArgumentsList() != null && ((AbstractOperationCall)OperationCallArgumentsListComposite.this.getRootEObject()).getArgumentsList().getArguments().indexOf(fromObject) != -1) {
                    return false;
                }
                return true;
            }
        }));
    }
}

