/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCallsListComposite
extends AbstractEListComposite<OperationCallsList, OperationCallsList, AbstractOperationCall> {
    private static final Logger Logger = LoggerFactory.getLogger(OperationCallsListComposite.class);
    private Label variableLabel;
    private Label typeLabel;
    private Label featureLabel;
    private Label eOperationLabel;
    private static final int NAME_COL_MIN_WIDTH = 200;
    private static final int FEATURE_COL_MIN_WIDTH = 200;
    private static final int COMMAND_COL_MIN_WIDTH = 200;

    public OperationCallsListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createRunButton(parent, style);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        nameColumn.getColumn().setText("Name");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((AbstractOperationCall)element).getName() == null ? "<unnamed>" : ((AbstractOperationCall)element).getName();
            }
        });
        TreeViewerColumn featureColumn = new TreeViewerColumn(viewer, 0);
        featureColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        featureColumn.getColumn().setText("Feature");
        featureColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String str = ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString((AbstractOperationCall)element);
                return str.contains("#") ? str.substring(0, str.indexOf("#")) : str;
            }
        });
        TreeViewerColumn commandColumn = new TreeViewerColumn(viewer, 0);
        commandColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        commandColumn.getColumn().setText("Command");
        commandColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String str = ApogyCoreInvocatorFacade.INSTANCE.getEOperationString(((AbstractOperationCall)element).getArgumentsList(), ((AbstractOperationCall)element).getEOperation());
                return str.substring(1, str.length());
            }
        });
    }

    protected void doNew() {
        EObjectWizard wizard = new EObjectWizard((EObject)((OperationCallsList)this.getResolvedEObject()), this.getFeaturePath(), (EReference)this.getEStructuralFeature(), ApogyCoreInvocatorPackage.Literals.OPERATION_CALL, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void createRunButtonBindings(Button button) {
        IObservableValue sessionStartDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_CREATION_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IObservableValue sessionDisposeDate = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.APOGY_CORE_INVOCATOR_FACADE__ACTIVE_INVOCATOR_SESSION, ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__ENVIRONMENT, ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT, ApogyCoreInvocatorPackage.Literals.CONTEXT__INSTANCES_DISPOSAL_DATE})).observe((Object)ApogyCoreInvocatorFacade.INSTANCE);
        IViewerObservableValue selectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ArrayList<Object> valesToWatch = new ArrayList<Object>();
        valesToWatch.add(sessionStartDate);
        valesToWatch.add(sessionDisposeDate);
        valesToWatch.add(selectionObservableValue);
        ISWTObservableValue buttonEnabledObservableValue = WidgetProperties.enabled().observe((Widget)button);
        for (IObservableValue iObservableValue : valesToWatch) {
            this.getDataBindingContext().bindValue((IObservableValue)buttonEnabledObservableValue, iObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(IConverter.create(Object.class, Boolean.class, o -> {
                if (o != null) {
                    Context activeContext = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession().getEnvironment().getActiveContext();
                    if (activeContext != null) {
                        Date startDate = activeContext.getInstancesCreationDate();
                        Date disposeDate = activeContext.getInstancesDisposalDate();
                        if (startDate != null && disposeDate == null) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            })));
        }
    }

    protected void doRun() {
        for (AbstractOperationCall opsCall : this.getSelectedItemObjects()) {
            try {
                ApogyCoreInvocatorFacade.INSTANCE.exec(opsCall);
            }
            catch (Throwable t) {
                Logger.error("Failed to execute operation call <" + opsCall.getName() + ">!", t);
            }
        }
    }

    protected Composite createDetailComposite(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(1, false));
        this.variableLabel = new Label(top, style);
        this.variableLabel.setText("Variable");
        this.typeLabel = new Label(top, style);
        this.typeLabel.setText("Type");
        this.eOperationLabel = new Label(top, style);
        this.eOperationLabel.setText("EOperation");
        return top;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        AbstractOperationCall operationCall;
        System.err.println("OperationCallsListComposite.selectionChanged()");
        AbstractOperationCall abstractOperationCall = operationCall = this.getSelectedItemObjects() != null && !this.getSelectedItemObjects().isEmpty() ? (AbstractOperationCall)this.getSelectedItemObjects().get(0) : null;
        if (operationCall != null) {
            this.variableLabel.setText("Variable: " + operationCall.getVariable() != null ? operationCall.getVariable().getName() : "unamed");
            this.typeLabel.setText("Feature: " + ApogyCoreInvocatorFacade.INSTANCE.getSubTypeFeatureString(operationCall.getTypeMemberReferenceListElement(), operationCall.getFeaturePath()));
            this.eOperationLabel.setText("Operation: " + ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString(operationCall, true));
        } else {
            this.variableLabel.setText("");
            this.typeLabel.setText("");
            this.eOperationLabel.setText("");
        }
    }
}

