/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TypeTypeMemberSelectionComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Type type;
    private TypeMember selectedTypeMember;
    private final ComboViewer comboViewer;

    public TypeTypeMemberSelectionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public TypeTypeMemberSelectionComposite(Composite parent, int style, Type type) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.type = type;
        this.comboViewer = this.createCombo(this, 8);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    TypeTypeMemberSelectionComposite.this.selectedTypeMember = null;
                    TypeTypeMemberSelectionComposite.this.newEClassSelected(TypeTypeMemberSelectionComposite.this.selectedTypeMember);
                    TypeTypeMemberSelectionComposite.this.comboViewer.getCombo().setToolTipText("");
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof EClass) {
                        TypeTypeMemberSelectionComposite.this.selectedTypeMember = (TypeMember)iStructuredSelection.getFirstElement();
                        TypeTypeMemberSelectionComposite.this.comboViewer.getCombo().setToolTipText(TypeTypeMemberSelectionComposite.this.selectedTypeMember.getName());
                        TypeTypeMemberSelectionComposite.this.newEClassSelected(TypeTypeMemberSelectionComposite.this.selectedTypeMember);
                    } else {
                        TypeTypeMemberSelectionComposite.this.selectedTypeMember = null;
                        TypeTypeMemberSelectionComposite.this.comboViewer.getCombo().setToolTipText("");
                        TypeTypeMemberSelectionComposite.this.newEClassSelected(TypeTypeMemberSelectionComposite.this.selectedTypeMember);
                    }
                }
            }
        });
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) {
        this.type = newType;
        if (newType != null) {
            this.comboViewer.setInput((Object)this.type.getMembers());
        }
    }

    public ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    public TypeMember getSelectedTypeMember() {
        return this.selectedTypeMember;
    }

    public void select(TypeMember typeMember) {
        if (this.comboViewer != null && !this.comboViewer.getCombo().isDisposed()) {
            if (typeMember != null) {
                this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)typeMember), true);
            } else {
                this.comboViewer.setSelection((ISelection)new StructuredSelection(), true);
            }
        }
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 4);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TypeMember typeMember1 = (TypeMember)e1;
                TypeMember typeMember2 = (TypeMember)e2;
                String name1 = typeMember1.getName();
                String name2 = typeMember2.getName();
                return name1.compareTo(name2);
            }
        });
        if (this.type != null && this.type.getMembers() != null) {
            comboViewer.setInput((Object)this.type.getMembers());
        }
        return comboViewer;
    }

    protected void newEClassSelected(TypeMember newTypeMember) {
    }
}

