/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.utils;

import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCallButtonManager {
    private static final Logger Logger = LoggerFactory.getLogger(OperationCallButtonManager.class);
    public OperationCallResult operationCallResult = null;
    protected Button managedButton = null;
    protected boolean notifyOnCompletion = true;
    protected String operationDescription = null;

    public OperationCallButtonManager(Button managedButton, String operationDescription, boolean notifyOnCompletion) {
        this.managedButton = managedButton;
        this.operationDescription = operationDescription;
        this.notifyOnCompletion = notifyOnCompletion;
    }

    public OperationCallResult execute(final AbstractOperationCall operationCall) {
        Job job = new Job(this.operationDescription){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Logger.info("Launching execution of " + OperationCallButtonManager.this.operationDescription);
                    OperationCallButtonManager.this.operationCallResult = ApogyCoreInvocatorFacade.INSTANCE.exec(operationCall);
                    if (OperationCallButtonManager.this.operationCallResult.getExceptionContainer() != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String message = "The following error occured during " + (this).OperationCallButtonManager.this.operationDescription + " : " + (this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException().toString();
                                    Logger.info(message, (this).OperationCallButtonManager.this.operationCallResult.getExceptionContainer().getException());
                                    MessageDialog.openError((Shell)(this).OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)"Take Scan Error", (String)message);
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    } else if (OperationCallButtonManager.this.notifyOnCompletion) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    String message = String.valueOf((this).OperationCallButtonManager.this.operationDescription) + " : Completed sucessfully.";
                                    Logger.info(message);
                                    MessageDialog.openInformation((Shell)(this).OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)(String.valueOf((this).OperationCallButtonManager.this.operationDescription) + " Success"), (String)message);
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = "The following error occured during " + (this).OperationCallButtonManager.this.operationDescription + " : " + e.toString();
                            Logger.info(message);
                            MessageDialog.openError((Shell)(this).OperationCallButtonManager.this.managedButton.getDisplay().getActiveShell(), (String)"Error", (String)message);
                        }
                    });
                }
                UIJob uiJob = new UIJob("Waiting for " + OperationCallButtonManager.this.operationDescription + " to complete."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!(this).OperationCallButtonManager.this.managedButton.isDisposed()) {
                            (this).OperationCallButtonManager.this.managedButton.setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
        return this.operationCallResult;
    }
}

