/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractFeatureTreeNode;
import org.eclipse.apogy.common.emf.AbstractRootNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TreeRootNode;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class TypeMemberFeatureNodeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.invocator.ui.wizards.TypeMemberFeatureNodeWizardPage";
    private final Type parentType;
    private final TypeMember typeMember;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Tree tree;
    private TreeViewer treeViewer;
    private Button btnNew;
    private Button btnDelete;
    private Button btnSelect;
    private Button btnClear;
    private Text txtSelectedAbstractFeatureTreeNode;
    private AbstractFeatureTreeNode selectedAbstractFeatureTreeNode = null;

    public TypeMemberFeatureNodeWizardPage(Type parentType, TypeMember typeMember) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Member mapping to System's feature");
        this.setDescription("Select the feature of the parent system to which this member should be mapped to. Use the NEW button to create the Feature Node that point to the required feature.");
        this.parentType = parentType;
        this.typeMember = typeMember;
    }

    public void createControl(Composite parent1) {
        Composite container = new Composite(parent1, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        this.setPageComplete(true);
        if (this.parentType != null && this.parentType.getInterfaceClass() != null) {
            this.treeViewer = new TreeViewer(container, 68352);
            this.tree = this.treeViewer.getTree();
            GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
            gd_tree.widthHint = 200;
            gd_tree.minimumWidth = 200;
            this.tree.setLayoutData((Object)gd_tree);
            this.tree.setLinesVisible(true);
            this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new CustomAdapterFactoryLabelProvider(this.adapterFactory));
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractFeatureTreeNode selectedNode = (AbstractFeatureTreeNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                    TypeMemberFeatureNodeWizardPage.this.setSelectedAbstractFeatureTreeNode(selectedNode);
                    if (selectedNode != null) {
                        TypeMemberFeatureNodeWizardPage.this.btnDelete.setEnabled(true);
                    } else {
                        TypeMemberFeatureNodeWizardPage.this.btnDelete.setEnabled(false);
                    }
                    if (selectedNode instanceof AbstractFeatureSpecifier) {
                        AbstractFeatureSpecifier abstractFeatureSpecifier = (AbstractFeatureSpecifier)selectedNode;
                        if (TypeMemberFeatureNodeWizardPage.this.isCompatibleWithFeatureSuperClass(abstractFeatureSpecifier)) {
                            TypeMemberFeatureNodeWizardPage.this.btnSelect.setEnabled(true);
                        } else {
                            TypeMemberFeatureNodeWizardPage.this.btnSelect.setEnabled(false);
                        }
                    }
                }
            });
            Composite composite = new Composite(container, 0);
            composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            composite.setLayout((Layout)new GridLayout(1, false));
            this.btnNew = new Button(composite, 0);
            this.btnNew.setSize(74, 29);
            this.btnNew.setText("New");
            this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnNew.setEnabled(true);
            this.btnNew.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13) {
                        AbstractFeatureTreeNode parent = null;
                        if (TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNode() == null) {
                            if (TypeMemberFeatureNodeWizardPage.this.typeMember.getTypeFeatureRootNode() == null) {
                                TreeRootNode treeRoot = ApogyCommonEMFFactory.eINSTANCE.createTreeRootNode();
                                treeRoot.setSourceClass(TypeMemberFeatureNodeWizardPage.this.parentType.getInterfaceClass());
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TypeMemberFeatureNodeWizardPage.this.typeMember, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TYPE_MEMBER__TYPE_FEATURE_ROOT_NODE, (Object)treeRoot, true);
                            }
                            parent = TypeMemberFeatureNodeWizardPage.this.typeMember.getTypeFeatureRootNode();
                        } else {
                            parent = TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNode();
                        }
                        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                        settings.getUserDataMap().put("parent", parent);
                        EObjectWizard wizard = new EObjectWizard((EObject)parent, null, ApogyCommonEMFPackage.Literals.ABSTRACT_FEATURE_TREE_NODE__CHILDREN, ApogyCommonEMFPackage.Literals.TREE_FEATURE_NODE, (EClassSettings)settings);
                        WizardDialog dialog = new WizardDialog(TypeMemberFeatureNodeWizardPage.this.getShell(), (IWizard)wizard);
                        dialog.open();
                        if (!TypeMemberFeatureNodeWizardPage.this.treeViewer.isBusy()) {
                            TypeMemberFeatureNodeWizardPage.this.treeViewer.setInput((Object)TypeMemberFeatureNodeWizardPage.this.typeMember.getTypeFeatureRootNode());
                            if (wizard.getCreatedEObject() != null) {
                                TypeMemberFeatureNodeWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)wizard.getCreatedEObject()));
                            }
                        }
                    }
                }
            });
            this.btnDelete = new Button(composite, 0);
            this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnDelete.setSize(74, 29);
            this.btnDelete.setText("Delete");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String deleteMessage = "";
                    Iterator<AbstractFeatureTreeNode> treeNodeIterator = TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNodes().iterator();
                    while (treeNodeIterator.hasNext()) {
                        AbstractFeatureSpecifier abstractFeatureSpecifier;
                        AbstractFeatureTreeNode treeNode = treeNodeIterator.next();
                        if (treeNode instanceof AbstractFeatureSpecifier && (abstractFeatureSpecifier = (AbstractFeatureSpecifier)treeNode).getStructuralFeature() != null) {
                            deleteMessage = abstractFeatureSpecifier.getStructuralFeature().getName();
                        }
                        if (!treeNodeIterator.hasNext()) continue;
                        deleteMessage = String.valueOf(deleteMessage) + ", ";
                    }
                    MessageDialog dialog = new MessageDialog(null, "Delete the selected Features", null, "Are you sure to delete these Features: " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                    int result = dialog.open();
                    if (result == 0) {
                        List<AbstractFeatureTreeNode> listOfNodesToRemove = TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNodes();
                        for (AbstractFeatureTreeNode nodeToRemove : listOfNodesToRemove) {
                            if (nodeToRemove instanceof AbstractRootNode) continue;
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)nodeToRemove.getParent(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.ABSTRACT_FEATURE_TREE_NODE__CHILDREN, (Object)nodeToRemove);
                        }
                    }
                    if (!TypeMemberFeatureNodeWizardPage.this.treeViewer.isBusy()) {
                        TypeMemberFeatureNodeWizardPage.this.treeViewer.setInput((Object)TypeMemberFeatureNodeWizardPage.this.typeMember.getTypeFeatureRootNode());
                    }
                }
            });
            Composite bottom = new Composite(container, 0);
            bottom.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            bottom.setLayout((Layout)new GridLayout(4, false));
            this.btnSelect = new Button(bottom, 0);
            this.btnSelect.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            this.btnSelect.setSize(74, 29);
            this.btnSelect.setText("Select");
            this.btnSelect.setEnabled(false);
            this.btnSelect.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (TypeMemberFeatureNodeWizardPage.this.txtSelectedAbstractFeatureTreeNode != null && !TypeMemberFeatureNodeWizardPage.this.txtSelectedAbstractFeatureTreeNode.isDisposed()) {
                        if (TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNode() != null) {
                            TypeMemberFeatureNodeWizardPage.this.txtSelectedAbstractFeatureTreeNode.setText(ApogyCommonEMFFacade.INSTANCE.getAncestriesString((AbstractFeatureNode)TypeMemberFeatureNodeWizardPage.this.getSelectedAbstractFeatureTreeNode()));
                        } else {
                            TypeMemberFeatureNodeWizardPage.this.txtSelectedAbstractFeatureTreeNode.setText("");
                        }
                    }
                    TypeMemberFeatureNodeWizardPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.btnClear = new Button(bottom, 0);
            this.btnClear.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            this.btnClear.setSize(74, 29);
            this.btnClear.setText("Clear");
            this.btnClear.setEnabled(true);
            this.btnClear.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TypeMemberFeatureNodeWizardPage.this.typeMember, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TYPE_MEMBER__TYPE_FEATURE_ROOT_NODE, null, true);
                    if (!TypeMemberFeatureNodeWizardPage.this.treeViewer.isBusy()) {
                        TypeMemberFeatureNodeWizardPage.this.treeViewer.refresh();
                    }
                    TypeMemberFeatureNodeWizardPage.this.txtSelectedAbstractFeatureTreeNode.setText("");
                    TypeMemberFeatureNodeWizardPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label lblFeature = new Label(bottom, 0);
            lblFeature.setText("Feature : ");
            lblFeature.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.txtSelectedAbstractFeatureTreeNode = new Text(bottom, 2048);
            this.txtSelectedAbstractFeatureTreeNode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.txtSelectedAbstractFeatureTreeNode.setEditable(false);
        }
    }

    public AbstractFeatureTreeNode getSelectedAbstractFeatureTreeNode() {
        return this.selectedAbstractFeatureTreeNode;
    }

    public void setSelectedAbstractFeatureTreeNode(AbstractFeatureTreeNode selectedAbstractFeatureTreeNode) {
        this.selectedAbstractFeatureTreeNode = selectedAbstractFeatureTreeNode;
    }

    public List<AbstractFeatureTreeNode> getSelectedAbstractFeatureTreeNodes() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.typeMember.getTypeFeatureRootNode() != null) {
            EReference typeMemberEReference = this.getEReference(this.typeMember.getTypeFeatureRootNode());
            for (TypeMember member : this.parentType.getMembers()) {
                EReference leafEReference;
                if (member == this.typeMember || member.getTypeFeatureRootNode() == null || typeMemberEReference != (leafEReference = this.getEReference(member.getTypeFeatureRootNode()))) continue;
                this.setErrorMessage("Another type member <" + member.getName() + "> in this system is mapped to " + ApogyCommonEMFFacade.INSTANCE.getAncestriesString((AbstractFeatureNode)this.getSelectedAbstractFeatureTreeNode()));
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private EReference getEReference(TreeRootNode treeRootNode) {
        AbstractFeatureSpecifier abstractFeatureSpecifier;
        AbstractFeatureNode abstractFeatureNode;
        if (treeRootNode != null && (abstractFeatureNode = this.getLeafRecursive((AbstractFeatureNode)treeRootNode)) instanceof AbstractFeatureSpecifier && (abstractFeatureSpecifier = (AbstractFeatureSpecifier)abstractFeatureNode).getStructuralFeature() instanceof EReference) {
            return (EReference)abstractFeatureSpecifier.getStructuralFeature();
        }
        return null;
    }

    private AbstractFeatureNode getLeafRecursive(AbstractFeatureNode root) {
        if (root instanceof AbstractFeatureTreeNode) {
            AbstractFeatureTreeNode abstractFeatureTreeNode = (AbstractFeatureTreeNode)root;
            if (abstractFeatureTreeNode.getChildren().size() == 0) {
                return abstractFeatureTreeNode;
            }
            return this.getLeafRecursive((AbstractFeatureNode)abstractFeatureTreeNode.getChildren().get(0));
        }
        return root;
    }

    private boolean isCompatibleWithFeatureSuperClass(AbstractFeatureSpecifier abstractFeatureSpecifier) {
        EStructuralFeature eStructuralFeature;
        if (abstractFeatureSpecifier != null && abstractFeatureSpecifier.getStructuralFeature() != null && (eStructuralFeature = abstractFeatureSpecifier.getStructuralFeature()) instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            Class referrencedClass = eReference.getEType().getInstanceClass();
            return this.typeMember.getMemberType().getInterfaceClass().getInstanceClass().isAssignableFrom(referrencedClass);
        }
        return false;
    }

    private class CustomAdapterFactoryLabelProvider
    extends AdapterFactoryLabelProvider {
        public CustomAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getImage(Object object) {
            if (TypeMemberFeatureNodeWizardPage.this.typeMember.getMemberType().getInterfaceClass().getInstanceClass() != null && object instanceof AbstractFeatureSpecifier) {
                AbstractFeatureSpecifier abstractFeatureSpecifier = (AbstractFeatureSpecifier)object;
                if (TypeMemberFeatureNodeWizardPage.this.isCompatibleWithFeatureSuperClass(abstractFeatureSpecifier)) {
                    return super.getImage(object);
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            }
            return super.getImage(object);
        }
    }
}

