/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.delegates;

import java.util.Iterator;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Disposable;
import org.eclipse.apogy.core.invocator.AbstractOperationCall;
import org.eclipse.apogy.core.invocator.AbstractTypeImplementation;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeApiAdapter;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.invocator.TypeMemberImplementation;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.core.invocator.delegates.InvocatorDelegate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInvocatorDelegate
implements InvocatorDelegate {
    private static final Logger Logger = LoggerFactory.getLogger(DefaultInvocatorDelegate.class);

    @Override
    public void newInstance(Environment environment, Variable variable) {
        VariableImplementation variableImplementation = environment.getActiveContext().getVariableImplementationsList().getVariableImplementation(variable);
        if (variableImplementation == null) {
            Logger.error("There is no implementation defined for the variable <" + variable.getName() + ">.");
        } else {
            EClass eClass = variableImplementation.getImplementationClass();
            if (eClass != null) {
                EObject eObject = EcoreUtil.create((EClass)eClass);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)variableImplementation, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__INSTANCE, (Object)eObject, true);
            }
            this.newInstance(environment, variableImplementation);
            this.newInstance(environment, variableImplementation.getTypeMemberImplementations().iterator());
            this.injectTypeMemberValue(variableImplementation);
            Logger.info("The variable <" + variable.getName() + "> has been instantiated.");
        }
    }

    protected void injectTypeMemberValue(AbstractTypeImplementation typeImplementation) {
        EObject srcObj = typeImplementation.getInstance();
        for (TypeMember typeMember : typeImplementation.getHandlingType().getMembers()) {
            if (typeMember.getTypeFeatureRootNode() == null) continue;
            TypeMemberImplementation subTypeMemberImplementation = typeImplementation.getTypeMemberImplementation(typeMember);
            if (typeMember.getTypeFeatureRootNode().getChildren().isEmpty()) continue;
            ApogyCommonEMFFacade.INSTANCE.setValue(srcObj, (AbstractFeatureNode)typeMember.getTypeFeatureRootNode().getChildren().get(0), (Object)subTypeMemberImplementation.getInstance());
        }
        for (TypeMemberImplementation current : typeImplementation.getTypeMemberImplementations()) {
            this.injectTypeMemberValue(current);
        }
    }

    @Override
    public void newInstance(Environment environment, AbstractTypeImplementation typeImplementation) {
        TypeApiAdapter typeApiAdapter = typeImplementation.getAdapterInstance();
        if (typeApiAdapter == null) {
            EClass typeApiAdapterEClass = typeImplementation.getHandlingType().getTypeApiAdapterClass();
            typeApiAdapter = typeApiAdapterEClass == null ? this.newDefaultTypeApiAdapter() : (TypeApiAdapter)EcoreUtil.create((EClass)typeApiAdapterEClass);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)typeImplementation, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__ADAPTER_INSTANCE, (Object)typeApiAdapter, true);
        }
        typeApiAdapter.init(environment, typeImplementation.getHandlingType(), typeImplementation.getInstance());
    }

    private void newInstance(Environment environment, Iterator<TypeMemberImplementation> typeMemberImplementations) {
        while (typeMemberImplementations.hasNext()) {
            TypeMemberImplementation typeMemberImplementation = typeMemberImplementations.next();
            EClass eClass = typeMemberImplementation.getImplementationClass();
            if (eClass != null) {
                EObject eObject = EcoreUtil.create((EClass)typeMemberImplementation.getImplementationClass());
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)typeMemberImplementation, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__INSTANCE, (Object)eObject, true);
            }
            this.newInstance(environment, typeMemberImplementation);
            this.newInstance(environment, typeMemberImplementation.getTypeMemberImplementations().iterator());
        }
    }

    @Override
    public void dispose(Environment environment, Variable variable) {
        VariableImplementation variableImplementation = environment.getActiveContext().getVariableImplementationsList().getVariableImplementation(variable);
        if (variableImplementation != null) {
            this.dispose(variableImplementation);
            this.dispose(variableImplementation.getTypeMemberImplementations().iterator());
        }
        Logger.info("The variable <" + variable.getName() + "> has been disposed.");
    }

    @Override
    public void dispose(AbstractTypeImplementation typeImplementation) {
        try {
            EObject eObject;
            if (typeImplementation.getAdapterInstance() != null) {
                typeImplementation.getAdapterInstance().dispose();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)typeImplementation, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__ADAPTER_INSTANCE, null, true);
            }
            if ((eObject = typeImplementation.getInstance()) instanceof Disposable) {
                ((Disposable)eObject).dispose();
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)typeImplementation, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ABSTRACT_TYPE_IMPLEMENTATION__INSTANCE, null, true);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private void dispose(Iterator<TypeMemberImplementation> typeMemberImplementations) {
        while (typeMemberImplementations.hasNext()) {
            try {
                TypeMemberImplementation typeMemberImplementation = typeMemberImplementations.next();
                this.dispose(typeMemberImplementation);
                this.dispose(typeMemberImplementation.getTypeMemberImplementations().iterator());
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    @Override
    public OperationCallResult execute(EObject instance, AbstractOperationCall operationCall, boolean saveResult) {
        TypeApiAdapter typeApiAdapter = ApogyCoreInvocatorFacade.INSTANCE.getTypeApiAdapter(operationCall);
        return typeApiAdapter.invoke(instance, operationCall, saveResult);
    }

    @Override
    public Class<? extends Type> getHandledTypeClass() {
        return Type.class;
    }

    @Override
    public TypeApiAdapter newDefaultTypeApiAdapter() {
        return ApogyCoreInvocatorFactory.eINSTANCE.createTypeApiAdapter();
    }
}

