/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.WorksiteContributor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorksiteContributorsRegistry {
    private static final Logger Logger = LoggerFactory.getLogger(WorksiteContributorsRegistry.class);
    public static final String WORKSITE_CONTRIBUTORS_POINT_ID = "org.eclipse.apogy.core.worksiteProvider";
    public static final String WORKSITE_CONTRIBUTORS_NAME_ID = "Name";
    public static final String WORKSITE_CONTRIBUTORS_DESCRIPTION_ID = "Description";
    public static final String WORKSITE_CONTRIBUTORS_URI_ID = "URI";
    private List<WorksiteContributor> registeredWorksiteProviders = null;

    public List<WorksiteContributor> getRegisteredWorksiteProviders() {
        if (this.registeredWorksiteProviders == null) {
            this.registeredWorksiteProviders = new ArrayList<WorksiteContributor>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(WORKSITE_CONTRIBUTORS_POINT_ID);
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                try {
                    String name = contributor.getAttribute(WORKSITE_CONTRIBUTORS_NAME_ID);
                    String description = contributor.getAttribute(WORKSITE_CONTRIBUTORS_DESCRIPTION_ID);
                    String uriString = contributor.getAttribute(WORKSITE_CONTRIBUTORS_URI_ID);
                    URI uri = URI.createURI((String)("platform:/plugin/" + contributor.getNamespaceIdentifier() + "/" + uriString), (boolean)true);
                    WorksiteContributor sessionContributor = new WorksiteContributor(name, description, uri);
                    this.registeredWorksiteProviders.add(sessionContributor);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            Logger.debug("Worksite Contributors :");
            for (WorksiteContributor worksiteContributor : this.registeredWorksiteProviders) {
                Logger.debug("\t Name        : " + worksiteContributor.name);
                Logger.debug("\t Description : " + worksiteContributor.description);
                Logger.debug("\t URI         : " + worksiteContributor.uri);
            }
            Logger.info("Found <" + this.registeredWorksiteProviders.size() + "> registered Worksite Providers.");
        }
        return this.registeredWorksiteProviders;
    }
}

