/*
 * Decompiled with CFR 0.152.
 */
package org.orekit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DirectoryCrawler;
import org.orekit.time.TimeScalesFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    public static String ID = "org.orekit";
    public static final String DATA_FOLDER = "data";
    private static Activator plugin;
    private static BundleContext context;
    private java.nio.file.Path tmpPath;

    public static BundleContext getContext() {
        return context;
    }

    public Activator() {
        plugin = this;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        try {
            Activator.logMessage(this, "Loading OreKit data...", 1);
            this.tmpPath = this.copyDataFolderToTemp(DATA_FOLDER);
            DataProvidersManager.getInstance().addProvider((DataProvider)new DirectoryCrawler(this.tmpPath.toFile()));
            try {
                TimeScalesFactory.getUTC();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Activator.logMessage(this, "Sucessfully loaded OreKit data.", 0);
        }
        catch (Throwable t) {
            Activator.logMessage(this, "Error cocured when loading OreKit Data !", 4, t);
        }
    }

    public void stop(BundleContext context) throws Exception {
        Activator.deleteFile(this.tmpPath.toFile());
        Activator.context = null;
    }

    public static void deleteFile(File element) {
        if (element.isDirectory()) {
            File[] fileArray = element.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                Activator.deleteFile(sub);
                ++n2;
            }
        }
        element.delete();
    }

    public static FrameworkLog getLog() {
        if (Activator.getContext() != null) {
            ServiceReference logService = Activator.getContext().getServiceReference("org.eclipse.osgi.framework.log.FrameworkLog");
            FrameworkLog log = (FrameworkLog)Activator.getContext().getService(logService);
            return log;
        }
        return null;
    }

    public static void logMessage(Object object, String message, int severity, Throwable throwable) {
        String fullMessage = String.valueOf(object.getClass().getSimpleName()) + " : " + message;
        FrameworkLogEntry logEntry = new FrameworkLogEntry(Activator.getContext().getBundle().getSymbolicName(), severity, 0, fullMessage, 0, throwable, null);
        if (Activator.getLog() != null) {
            Activator.getLog().log(logEntry);
        }
    }

    public static void logMessage(Object object, String message, int severity) {
        Activator.logMessage(object, message, severity, null);
    }

    private java.nio.file.Path copyDataFolderToTemp(String folderPath) throws Exception {
        java.nio.file.Path tempPath = Files.createTempDirectory("oreKit", new FileAttribute[0]);
        Enumeration entries = Activator.getContext().getBundle().getEntryPaths(folderPath);
        while (entries.hasMoreElements()) {
            try {
                String entry = (String)entries.nextElement();
                URL url = Activator.getContext().getBundle().getEntry(entry);
                Path p = new Path(String.valueOf(ID) + File.separator + folderPath + File.separator + url.getFile());
                if (p.hasTrailingSeparator()) continue;
                String fileName = entry.substring(entry.lastIndexOf(File.separator) + 1);
                InputStream input = url.openConnection().getInputStream();
                FileOutputStream output = new FileOutputStream(String.valueOf(tempPath.toString()) + File.separator + fileName);
                byte[] buffer = new byte[256];
                while (input.read(buffer) != -1) {
                    output.write(buffer);
                }
                input.close();
                output.flush();
                output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tempPath;
    }
}

