/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.parameter;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ros.exception.ParameterClassCastException;
import org.ros.exception.ParameterNotFoundException;
import org.ros.internal.node.client.ParameterClient;
import org.ros.internal.node.parameter.ParameterManager;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.response.StatusCode;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.namespace.GraphName;
import org.ros.namespace.NameResolver;
import org.ros.node.parameter.ParameterListener;
import org.ros.node.parameter.ParameterTree;

public class DefaultParameterTree
implements ParameterTree {
    private final ParameterClient parameterClient;
    private final ParameterManager parameterManager;
    private final NameResolver resolver;

    public static DefaultParameterTree newFromNodeIdentifier(NodeIdentifier nodeIdentifier, URI masterUri, NameResolver resolver, ParameterManager parameterManager) {
        ParameterClient client = new ParameterClient(nodeIdentifier, masterUri);
        return new DefaultParameterTree(client, parameterManager, resolver);
    }

    private DefaultParameterTree(ParameterClient parameterClient, ParameterManager parameterManager, NameResolver resolver) {
        this.parameterClient = parameterClient;
        this.parameterManager = parameterManager;
        this.resolver = resolver;
    }

    @Override
    public boolean has(GraphName name) {
        GraphName resolvedName = this.resolver.resolve(name);
        return this.parameterClient.hasParam(resolvedName).getResult();
    }

    @Override
    public boolean has(String name) {
        return this.has(GraphName.of(name));
    }

    @Override
    public void delete(GraphName name) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.deleteParam(resolvedName);
    }

    @Override
    public void delete(String name) {
        this.delete(GraphName.of(name));
    }

    @Override
    public GraphName search(GraphName name) {
        GraphName resolvedName = this.resolver.resolve(name);
        Response<GraphName> response = this.parameterClient.searchParam(resolvedName);
        if (response.getStatusCode() == StatusCode.SUCCESS) {
            return response.getResult();
        }
        return null;
    }

    @Override
    public GraphName search(String name) {
        return this.search(GraphName.of(name));
    }

    public List<GraphName> getNames() {
        return this.parameterClient.getParamNames().getResult();
    }

    @Override
    public void addParameterListener(GraphName name, ParameterListener listener) {
        this.parameterManager.addListener(name, listener);
        this.parameterClient.subscribeParam(name);
    }

    @Override
    public void addParameterListener(String name, ParameterListener listener) {
        this.addParameterListener(GraphName.of(name), listener);
    }

    @Override
    public void set(GraphName name, boolean value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, boolean value) {
        this.set(GraphName.of(name), value);
    }

    @Override
    public void set(GraphName name, int value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, int value) {
        this.set(GraphName.of(name), value);
    }

    @Override
    public void set(GraphName name, double value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, double value) {
        this.set(GraphName.of(name), value);
    }

    @Override
    public void set(GraphName name, String value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, String value) {
        this.set(GraphName.of(name), value);
    }

    @Override
    public void set(GraphName name, List<?> value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, List<?> value) {
        this.set(GraphName.of(name), value);
    }

    @Override
    public void set(GraphName name, Map<?, ?> value) {
        GraphName resolvedName = this.resolver.resolve(name);
        this.parameterClient.setParam(resolvedName, value);
    }

    @Override
    public void set(String name, Map<?, ?> value) {
        this.set(GraphName.of(name), value);
    }

    private <T> T get(GraphName name, Class<T> type) {
        GraphName resolvedName = this.resolver.resolve(name);
        Response<Object> response = this.parameterClient.getParam(resolvedName);
        try {
            if (response.getStatusCode() == StatusCode.SUCCESS) {
                return type.cast(response.getResult());
            }
        }
        catch (ClassCastException e) {
            throw new ParameterClassCastException("Cannot cast parameter to: " + type.getName(), e);
        }
        throw new ParameterNotFoundException("Parameter does not exist: " + name);
    }

    private <T> T get(GraphName name, T defaultValue) {
        Preconditions.checkNotNull(defaultValue);
        GraphName resolvedName = this.resolver.resolve(name);
        Response<Object> response = this.parameterClient.getParam(resolvedName);
        if (response.getStatusCode() == StatusCode.SUCCESS) {
            try {
                return (T)defaultValue.getClass().cast(response.getResult());
            }
            catch (ClassCastException e) {
                throw new ParameterClassCastException("Cannot cast parameter to: " + defaultValue.getClass().getName(), e);
            }
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(GraphName name) {
        return (Boolean)((Object)this.get(name, (Object)Boolean.class));
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(GraphName.of(name));
    }

    @Override
    public boolean getBoolean(GraphName name, boolean defaultValue) {
        return this.get(name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBoolean(GraphName.of(name), defaultValue);
    }

    @Override
    public int getInteger(GraphName name) {
        return (Integer)((Object)this.get(name, (Object)Integer.class));
    }

    @Override
    public int getInteger(String name) {
        return this.getInteger(GraphName.of(name));
    }

    @Override
    public int getInteger(GraphName name, int defaultValue) {
        return this.get(name, defaultValue);
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        return this.getInteger(GraphName.of(name), defaultValue);
    }

    @Override
    public double getDouble(GraphName name) {
        return (Double)((Object)this.get(name, (Object)Double.class));
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(GraphName.of(name));
    }

    @Override
    public double getDouble(GraphName name, double defaultValue) {
        return this.get(name, defaultValue);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        return this.getDouble(GraphName.of(name), defaultValue);
    }

    @Override
    public String getString(GraphName name) {
        return (String)((Object)this.get(name, (Object)String.class));
    }

    @Override
    public String getString(String name) {
        return (String)((Object)this.get(GraphName.of(name), (Object)String.class));
    }

    @Override
    public String getString(GraphName name, String defaultValue) {
        return this.get(name, defaultValue);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.getString(GraphName.of(name), defaultValue);
    }

    @Override
    public List<?> getList(GraphName name) {
        return Arrays.asList((Object[])this.get(name, (Object)Object[].class));
    }

    @Override
    public List<?> getList(String name) {
        return this.getList(GraphName.of(name));
    }

    @Override
    public List<?> getList(GraphName name, List<?> defaultValue) {
        return Arrays.asList(this.get(name, defaultValue.toArray()));
    }

    @Override
    public List<?> getList(String name, List<?> defaultValue) {
        return this.getList(GraphName.of(name), defaultValue);
    }

    @Override
    public Map<?, ?> getMap(GraphName name) {
        return (Map)((Object)this.get(name, (Object)Map.class));
    }

    @Override
    public Map<?, ?> getMap(String name) {
        return this.getMap(GraphName.of(name));
    }

    @Override
    public Map<?, ?> getMap(GraphName name, Map<?, ?> defaultValue) {
        return this.get(name, defaultValue);
    }

    @Override
    public Map<?, ?> getMap(String name, Map<?, ?> defaultValue) {
        return this.getMap(GraphName.of(name), defaultValue);
    }
}

