/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters091.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters091.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters091.utils.HelperUtils_090_091;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CustomPropertiesConverter
extends AbstractConverter {
    public CustomPropertiesConverter() {
        this.helper = HelperUtils_090_091.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.0 to 0.9.1  : Executing \"CustomProperties converter\" for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateTimeObject(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void migrateTimeObject(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//value[@xsi:type=\"am:TimeObject\"]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//values[@xsi:type=\"am:TimeObject\"]");
        List timeObjectElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element timeObjectElement : timeObjectElements) {
            Attribute typeAttribute = timeObjectElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (typeAttribute == null) continue;
            typeAttribute.setValue("am:Time");
        }
    }
}

