/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing Software converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateRunnable(rootElement);
        this.updateActivations(rootElement);
        this.updateAllAbstractProcessElements(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateAllAbstractProcessElements(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes");
        List abstractProcessElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element abstractProcessElement : abstractProcessElements) {
            Attribute osekTaskGroupAttribute;
            Attribute priorityAttribute = abstractProcessElement.getAttribute("priority");
            if (priorityAttribute != null) {
                String value = priorityAttribute.getValue();
                abstractProcessElement.removeAttribute(priorityAttribute);
                if (!value.equals("0")) {
                    Element customPropertiesElement = new Element("customProperties");
                    customPropertiesElement.setAttribute("key", "priority");
                    Element valueElement = new Element("value");
                    valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
                    valueElement.setAttribute("value", value);
                    customPropertiesElement.addContent((Content)valueElement);
                    abstractProcessElement.addContent((Content)customPropertiesElement);
                    this.logger.info((Object)("Priority is removed from : " + abstractProcessElement.getName() + " element (" + abstractProcessElement.getAttributeValue("name") + ") and added as a CustomProperty with key as Priority"));
                }
            }
            if (!abstractProcessElement.getName().equals("tasks") || (osekTaskGroupAttribute = abstractProcessElement.getAttribute("osekTaskGroup")) == null) continue;
            String osekTaskGroupValue = osekTaskGroupAttribute.getValue();
            abstractProcessElement.removeAttribute(osekTaskGroupAttribute);
            if (osekTaskGroupValue.equals("0")) continue;
            this.addCustomProperty(abstractProcessElement, "osekTaskGroup", osekTaskGroupValue);
            this.logger.info((Object)("osekTaskGroup attribute is removed from Task (" + abstractProcessElement.getAttributeValue("name") + ") and added as a CustomProperty with key as osekTaskGroup"));
        }
    }

    private void updateRunnable(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/runnables");
        List runnableElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element runnableElement : runnableElements) {
            Attribute activationAttribute = runnableElement.getAttribute("activation");
            Element activationElement = runnableElement.getChild("activation");
            if (activationAttribute != null) {
                activationAttribute.setName("activations");
                continue;
            }
            if (activationElement == null) continue;
            activationElement.setName("activations");
        }
    }

    private void updateActivations(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/activations");
        List activationElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        boolean removedDeadLine = false;
        for (Element activationElement : activationElements) {
            Attribute triggerAttribute;
            if (activationElement.getAttributeValue("type", this.helper.getGenericNS("xsi")).contains("am:PeriodicActivation")) {
                Element deadlineElement = activationElement.getChild("deadline");
                if (deadlineElement == null) continue;
                deadlineElement.detach();
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", "deadline");
                deadlineElement.setName("value");
                deadlineElement.setAttribute("type", "am:TimeObject", this.helper.getGenericNS("xsi"));
                customPropertiesElement.addContent((Content)deadlineElement);
                activationElement.addContent((Content)customPropertiesElement);
                removedDeadLine = true;
                continue;
            }
            if (!activationElement.getAttributeValue("type", this.helper.getGenericNS("xsi")).contains("am:EventActivation")) continue;
            List triggerElements = activationElement.getChildren("trigger");
            if (triggerElements != null) {
                for (Element element : triggerElements) {
                    element.setName("triggeringEvents");
                }
            }
            if ((triggerAttribute = activationElement.getAttribute("trigger")) == null) continue;
            triggerAttribute.setName("triggeringEvents");
        }
        if (removedDeadLine) {
            this.logger.warn((Object)"-- Deadline inside PeriodicActivation elements is removed, as there is no equivalent element for it in AMALTHEA 0.8.1");
        }
    }
}

