/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters096.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters096.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters096.utils.HelperUtils_095_096;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ConstraintsConverter
extends AbstractConverter {
    public ConstraintsConverter() {
        this.helper = HelperUtils_095_096.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.5 to 0.9.6 : Executing Constraints converter for model file : " + file.getName()));
        this.basicConvert(file, map, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateEventChains(rootElement);
    }

    private void updateEventChains(Element rootElement) {
        List eventChains = this.helper.getXpathResult(rootElement, "./constraintsModel/eventChains", Element.class, new Namespace[]{this.helper.getNS_096("am"), this.helper.getGenericNS("xsi")});
        boolean hasSegments = false;
        for (Element element : eventChains) {
            hasSegments = false;
            ArrayList<Element> segments = new ArrayList<Element>(element.getChildren("segments"));
            if (!segments.isEmpty()) {
                this.convertToItems(segments, element, "sequence");
                hasSegments = true;
            }
            ArrayList<Element> strands = new ArrayList<Element>(element.getChildren("strands"));
            if (hasSegments && !strands.isEmpty()) {
                this.logger.info((Object)"EventChains Migration from 0.9.5 to 0.9.6 : Removing strands because Segments are already migrated and both cannot exist at a time in 0.9.6.");
                for (Element strand : strands) {
                    strand.detach();
                }
                continue;
            }
            if (strands.isEmpty()) continue;
            this.convertToItems(strands, element, "parallel");
        }
    }

    private void convertToItems(List<Element> segments, Element eventChain, String itemType) {
        Attribute itemTypeAttr = new Attribute("itemType", itemType);
        eventChain.setAttribute(itemTypeAttr);
        for (Element element : segments) {
            element.setName("items");
            if (!element.getAttributeValue("type", this.helper.getGenericNS("xsi")).equals("am:EventChainContainer")) continue;
            Element subevent = element.getChild("eventChain");
            subevent.setAttribute("minItemsCompleted", "1");
            eventChain.setAttribute("minItemsCompleted", "1");
        }
    }

    private void updateCustomPropsToCounter(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        List customProps = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_096("am"), this.helper.getGenericNS("xsi")});
        for (Element element : customProps) {
            Element parentElement = element.getParentElement();
            ArrayList customProperties = new ArrayList(parentElement.getChildren("customProperties"));
            Element counter = new Element("counter");
            parentElement.addContent((Content)counter);
            for (Element prop : customProperties) {
                if (prop.getAttributeValue("key").equals("counter-prescaler")) {
                    counter.setAttribute("prescaler", prop.getChild("value").getAttributeValue("value"));
                    prop.detach();
                    continue;
                }
                if (!prop.getAttributeValue("key").equals("counter-offset")) continue;
                counter.setAttribute("offset", prop.getChild("value").getAttributeValue("value"));
                prop.detach();
            }
        }
    }
}

