/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters096.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters096.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters096.utils.HelperUtils_095_096;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_095_096.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.5 to 0.9.6 : Executing Sw converter for model file : " + file.getName()));
        this.basicConvert(file, map, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateCustomPropsToCounter(rootElement);
        this.updateModeConditions(rootElement);
    }

    private void updateModeConditions(Element rootElement) {
        this.updateModeCondition(rootElement);
        this.updateModeConditionConjunction(rootElement);
    }

    private void updateModeCondition(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeCondition\"]");
        List modeCondition = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_096("am"), this.helper.getGenericNS("xsi")});
        for (Element element : modeCondition) {
            element.setAttribute("type", "am:ModeValueCondition", this.helper.getGenericNS("xsi"));
        }
    }

    private void updateModeConditionConjunction(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph/items//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./stimuliModel/stimuli/executionCondition//entries[@xsi:type=\"am:ModeConditionConjunction\"]");
        List modeConditions = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_096("am"), this.helper.getGenericNS("xsi")});
        for (Element element : modeConditions) {
            List entries = element.getChildren("entries");
            for (Element entry : entries) {
                entry.setAttribute("type", "am:ModeValueCondition", this.helper.getGenericNS("xsi"));
            }
        }
    }

    private void updateCustomPropsToCounter(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/callGraph//items[@xsi:type=\"am:RunnableCall\"]/customProperties[@key=\"counter-prescaler\"]");
        List customProps = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_096("am"), this.helper.getGenericNS("xsi")});
        for (Element element : customProps) {
            Element parentElement = element.getParentElement();
            ArrayList customProperties = new ArrayList(parentElement.getChildren("customProperties"));
            Element counter = new Element("counter");
            parentElement.addContent((Content)counter);
            for (Element prop : customProperties) {
                if (prop.getAttributeValue("key").equals("counter-prescaler")) {
                    counter.setAttribute("prescaler", prop.getChild("value").getAttributeValue("value"));
                    prop.detach();
                    continue;
                }
                if (!prop.getAttributeValue("key").equals("counter-offset")) continue;
                counter.setAttribute("offset", prop.getChild("value").getAttributeValue("value"));
                prop.detach();
            }
        }
    }
}

