/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters080.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters080.utils.HelperUtils_072_080;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SwConverter
extends AbstractConverter {
    public SwConverter() {
        this.helper = HelperUtils_072_080.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.2 to 0.8.0 : Executing SW converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_mode_Label(rootElement);
        this.update_DataSize(rootElement);
        this.update_ProbabiltitySwitch(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_ProbabiltitySwitch(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/tasks//*[@xsi:type=\"am:ProbabiltitySwitch\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs//*[@xsi:type=\"am:ProbabilitySwitch\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element probabilitySwitchElement : elements) {
            Attribute attribute = probabilitySwitchElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (attribute == null) continue;
            attribute.setValue("am:ProbabilitySwitch");
        }
    }

    private void update_DataSize(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./swModel/typeDefinitions[@xsi:type=\"am:BaseTypeDefinition\"]/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/memoryTypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/runnableItems//transmissionPolicy/chunkSize");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/modeLabels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/channels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/customEntities/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/size");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element dataSizeElement : elements) {
            Attribute attribute = dataSizeElement.getAttribute("unit");
            if (attribute == null) continue;
            String value = attribute.getValue();
            if (value.equals("kibit")) {
                attribute.setValue("Kibit");
                continue;
            }
            if (!value.equals("byte")) continue;
            attribute.setValue("B");
        }
    }

    private void update_mode_Label(Element rootElement) {
        StringBuffer labelXpathBuffer = new StringBuffer();
        labelXpathBuffer.append("./swModel/modeLabels");
        List elements = this.helper.getXpathResult(rootElement, labelXpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element modeLabel : elements) {
            Attribute modeAttribute = modeLabel.getAttribute("mode");
            if (modeAttribute != null) {
                modeLabel.removeAttribute(modeAttribute);
                continue;
            }
            Element modeElement = modeLabel.getChild("mode");
            if (modeElement == null) continue;
            modeLabel.removeChild("mode");
        }
    }
}

