/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters095.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters095.utils.HelperUtils_094_095;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StimuliConverter
extends AbstractConverter {
    public StimuliConverter() {
        this.helper = HelperUtils_094_095.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File file, Map<File, Document> map, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.9.4 to 0.9.5 : Executing Stimuli converter for model file : " + file.getName()));
        this.basicConvert(file, map, caches);
    }

    public void basicConvert(File file, Map<File, Document> map, List<ICache> caches) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.update_Scenario(rootElement);
        this.update_ClocksMulitplierList(rootElement);
        this.update_ClockSineFunction(rootElement);
        this.update_ClockTriangleFunction(rootElement);
    }

    private void update_Scenario(Element rootElement) {
        List scenarios = this.helper.getXpathResult(rootElement, "./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]/scenario", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element element : scenarios) {
            Element recurrence = element.getChild("recurrence");
            if (recurrence == null) continue;
            recurrence.detach();
            String value = recurrence.getAttributeValue("value");
            String unit = recurrence.getAttributeValue("unit");
            this.addCustomProperty(element, "old_definition_v0.9.4", "recurrence=" + value + unit);
        }
    }

    private void update_ClockSineFunction(Element rootElement) {
        List clocks = this.helper.getXpathResult(rootElement, "./stimuliModel/clocks[@xsi:type=\"am:ClockSinusFunction\"]", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", this.helper.getGenericNS("xsi"));
            element.setAttribute("curveType", "sine");
            Attribute amplitude = element.getAttribute("amplitude");
            amplitude.detach();
            customPropsValue.append(this.getStringValue(amplitude));
            customPropsValue.append(" ");
            Attribute offset = element.getAttribute("yOffset");
            offset.detach();
            customPropsValue.append(this.getStringValue(offset));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, "old_definition_v0.9.4", customPropsValue.toString().trim());
        }
    }

    private void update_ClockTriangleFunction(Element rootElement) {
        List clocks = this.helper.getXpathResult(rootElement, "./stimuliModel/clocks[@xsi:type=\"am:ClockTriangleFunction\"]", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        StringBuilder customPropsValue = new StringBuilder();
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockFunction", this.helper.getGenericNS("xsi"));
            element.setAttribute("curveType", "triangle");
            Attribute max = element.getAttribute("max");
            max.detach();
            customPropsValue.append(this.getStringValue(max));
            customPropsValue.append(" ");
            Attribute min = element.getAttribute("min");
            min.detach();
            customPropsValue.append(this.getStringValue(min));
            customPropsValue.append(" ");
            customPropsValue.append(this.extractPeriodAndShift(element));
            this.addCustomProperty(element, "old_definition_v0.9.4", customPropsValue.toString().trim());
        }
    }

    private String extractPeriodAndShift(Element element) {
        StringBuilder str = new StringBuilder();
        List children = element.getChildren();
        for (Element e : children) {
            str.append(e.getName());
            str.append("=");
            str.append(e.getAttributeValue("value"));
            str.append(e.getAttributeValue("unit"));
            str.append(" ");
        }
        element.removeChild("period");
        element.removeChild("shift");
        return str.toString();
    }

    private String getStringValue(Attribute attr) {
        String str = String.valueOf(attr.getName()) + "=" + attr.getValue();
        return str;
    }

    private void update_ClocksMulitplierList(Element rootElement) {
        List clocks = this.helper.getXpathResult(rootElement, "./stimuliModel/clocks[@xsi:type=\"am:ClockMultiplierList\"]", Element.class, new Namespace[]{this.helper.getNS_094("am"), this.helper.getGenericNS("xsi")});
        for (Element element : clocks) {
            element.setAttribute("type", "am:ClockStepList", this.helper.getGenericNS("xsi"));
            this.update_ClockEntries(element);
        }
    }

    private void update_ClockEntries(Element clockElement) {
        List entries = clockElement.getChildren("entries");
        for (Element entry : entries) {
            Attribute multiplier = entry.getAttribute("multiplier");
            multiplier.detach();
            this.addCustomProperty(entry, "old_definition_v0.9.4", "multiplier=" + multiplier.getValue());
        }
    }

    private void addCustomProperty(Element element, String key, String value) {
        Element customProps = new Element("customProperties");
        customProps.setAttribute("key", key);
        Element valueElement = new Element("value");
        valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
        valueElement.setAttribute("value", value);
        customProps.addContent((Content)valueElement);
        element.addContent((Content)customProps);
    }
}

