/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.eclipse.app4mc.amalthea.converters093.utils.PUDefinition_IPCData;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);
    private PUDefinition_IPCData cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.2 to 0.9.3 : Executing Sw converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getHWCache(caches);
        if (this.cache == null) {
            throw new IllegalStateException("PUDefinition_IPCData is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_ExecutionNeed(rootElement);
        this.update_ChunkProcessingInstructions(rootElement);
        this.update_activations(rootElement);
    }

    private void update_activations(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/activations");
        List activationElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element activationElement : activationElements) {
            Element activationDeviation_Time_deviationElement;
            int indexOf;
            Element migratedElement;
            String activationType = activationElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (activationType == null) continue;
            if (activationType.equals("am:VariableRateActivation")) {
                Element occurrencesPerStep_double_deviationElement = activationElement.getChild("occurrencesPerStep");
                if (occurrencesPerStep_double_deviationElement == null) continue;
                migratedElement = HelperUtils_092_093.migrateDeviationElement_Containing_DoubleValue(occurrencesPerStep_double_deviationElement, "occurrencesPerStep");
                indexOf = activationElement.indexOf((Content)occurrencesPerStep_double_deviationElement);
                activationElement.removeContent((Content)occurrencesPerStep_double_deviationElement);
                if (migratedElement == null) continue;
                activationElement.addContent(indexOf, (Content)migratedElement);
                continue;
            }
            if (!activationType.equals("am:SporadicActivation") || (activationDeviation_Time_deviationElement = activationElement.getChild("activationDeviation")) == null) continue;
            migratedElement = HelperUtils_092_093.migrateDeviationElement_Containing_TimeValue(activationDeviation_Time_deviationElement, "activationDeviation");
            indexOf = activationElement.indexOf((Content)activationDeviation_Time_deviationElement);
            activationElement.removeContent((Content)activationDeviation_Time_deviationElement);
            if (migratedElement == null) continue;
            activationElement.addContent(indexOf, (Content)migratedElement);
            migratedElement.setName("occurrence");
        }
    }

    private void update_ChunkProcessingInstructions(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:LabelAccess\" or @xsi:type=\"am:ChannelSend\" or @xsi:type=\"am:ChannelReceive\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:LabelAccess\"]/transmissionPolicy");
        List transmissionPolicyElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element transmissionPolicyElement : transmissionPolicyElements) {
            Attribute attribute = transmissionPolicyElement.getAttribute("chunkProcessingInstructions");
            if (attribute == null) continue;
            attribute.setName("chunkProcessingTicks");
        }
    }

    private void update_ExecutionNeed(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables//*[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/computationItems[@xsi:type=\"am:ExecutionNeed\"]");
        List executionNeeds = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element executionNeedElement : executionNeeds) {
            String containerElementName = null;
            String containerType = "";
            Element parentElement = HelperUtil.getParentElementOfName((Element)executionNeedElement, (String[])new String[]{"runnables", "taskSchedulers", "interruptControllers"});
            if (parentElement != null) {
                containerElementName = parentElement.getAttributeValue("name");
                if (parentElement.getName().equals("runnables")) {
                    containerType = "Runnable";
                } else if (parentElement.getName().equals("taskSchedulers")) {
                    containerType = "TaskScheduler";
                } else if (parentElement.getName().equals("interruptControllers")) {
                    containerType = "InterruptController";
                }
            }
            String nodeName = executionNeedElement.getName();
            List defaultElements = executionNeedElement.getChildren("default");
            LinkedHashMap<String, Element> defaultElementsMap = new LinkedHashMap<String, Element>();
            for (Element defaultElement : defaultElements) {
                String key = defaultElement.getAttributeValue("key");
                if (key == null) continue;
                defaultElementsMap.put(key, defaultElement);
            }
            Element newExecutionTicksElement = null;
            Element newExecutionNeedsElement = null;
            Set entrySet = defaultElementsMap.entrySet();
            for (Map.Entry next : entrySet) {
                Element newNeedElementValue;
                Element valueElement;
                Attribute typeAttribute;
                String key = (String)next.getKey();
                if (key.equals("Instructions")) {
                    Element defaultInstructionsElement = (Element)defaultElementsMap.get("Instructions");
                    newExecutionTicksElement = new Element(nodeName);
                    typeAttribute = new Attribute("type", "am:Ticks", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                    Element valueElement2 = defaultInstructionsElement.getChild("value");
                    Element default_executionTicksElement = this.createTicksElementFromNeed(valueElement2, "default", 1.0);
                    if (default_executionTicksElement == null) continue;
                    newExecutionTicksElement.addContent((Content)default_executionTicksElement);
                    continue;
                }
                if (containerType.equals("TaskScheduler") || containerType.equals("InterruptController")) {
                    LOGGER.warn("In {} : {}, ExecutionNeed element's NeedEntry (having HwFeatureCategory : {})-> can not be migrated. As this is not supported in 0.9.3. \nIn {} element only NeedEntry elements having HwFeatureCategory Instructions are migrated to Ticks", new Object[]{containerType, containerElementName, key, containerType});
                    continue;
                }
                Element defaultExecutionNeedElement = (Element)defaultElementsMap.get(key);
                if (newExecutionNeedsElement == null) {
                    newExecutionNeedsElement = new Element(nodeName);
                    typeAttribute = new Attribute("type", "am:ExecutionNeed", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                    newExecutionNeedsElement.getAttributes().add(typeAttribute);
                }
                if ((valueElement = defaultExecutionNeedElement.getChild("value")) == null || (newNeedElementValue = this.createTicksElementFromNeed(valueElement, "value", 1.0)) == null) continue;
                Element needsElement = new Element("needs");
                needsElement.setAttribute(new Attribute("key", key));
                needsElement.addContent((Content)newNeedElementValue);
                newExecutionNeedsElement.addContent((Content)needsElement);
            }
            List extendedElements = executionNeedElement.getChildren("extended");
            for (Element extendedElement : extendedElements) {
                Double ipcValue = this.getIPCValue(extendedElement);
                List valueElements = HelperUtil.getXpathResult((Element)extendedElement, (String)"./value[@key=\"Instructions\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am")});
                if (valueElements.size() <= 0) continue;
                Element extended_executionTicksElement = new Element("extended");
                HelperUtil.copyElement_Attribute_or_Element((Element)extendedElement, (Element)extended_executionTicksElement, (String)"key");
                Element valueElement = (Element)valueElements.get(0);
                Element valueValueElement = valueElement.getChild("value");
                Element value_executionTicksElement = this.createTicksElementFromNeed(valueValueElement, "value", ipcValue);
                if (value_executionTicksElement == null) continue;
                extended_executionTicksElement.addContent((Content)value_executionTicksElement);
                if (newExecutionTicksElement == null) {
                    newExecutionTicksElement = new Element(nodeName);
                    Attribute typeAttribute = new Attribute("type", "am:Ticks", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                    newExecutionTicksElement.getAttributes().add(typeAttribute);
                }
                newExecutionTicksElement.addContent((Content)extended_executionTicksElement);
            }
            ArrayList<Element> newRunnableItemElementsList = new ArrayList<Element>();
            if (newExecutionTicksElement != null) {
                newRunnableItemElementsList.add(newExecutionTicksElement);
            }
            if (newExecutionNeedsElement != null) {
                newRunnableItemElementsList.add(newExecutionNeedsElement);
            }
            Parent parent = executionNeedElement.getParent();
            int indexOf = parent.indexOf((Content)executionNeedElement);
            if (newRunnableItemElementsList.size() > 0) {
                parent.addContent(indexOf, newRunnableItemElementsList);
            }
            List skippedValuesExtended = HelperUtil.getXpathResult((Element)executionNeedElement, (String)"./extended/value[not(@key=\"Instructions\")]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am")});
            List skippedValuesDefault = HelperUtil.getXpathResult((Element)executionNeedElement, (String)"./default[not(@key=\"Instructions\")]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am")});
            StringBuilder extendedElementsbuffer = new StringBuilder();
            for (Element elementKey : skippedValuesExtended) {
                String attributeValue = elementKey.getAttributeValue("key");
                extendedElementsbuffer.append(attributeValue);
                extendedElementsbuffer.append(",");
            }
            StringBuilder defaultElementsbuffer = new StringBuilder();
            for (Element elementKey : skippedValuesDefault) {
                String attributeValue = elementKey.getAttributeValue("key");
                defaultElementsbuffer.append(attributeValue);
                defaultElementsbuffer.append(",");
            }
            if (extendedElementsbuffer.length() > 0) {
                LOGGER.info("In {} : \"{}, \" Entries of ExecutionNeed (extended elements) with following keys can not be migrated : {} -> (only supported \"HwFeatureCategory\" as key is : \"Instructions\")", new Object[]{containerType, containerElementName, extendedElementsbuffer.toString().substring(0, extendedElementsbuffer.length() - 1)});
            }
            if (defaultElementsbuffer.length() > 0 && (containerType.equals("TaskScheduler") || containerType.equals("InterruptController"))) {
                LOGGER.info("In {} : \"{}, \" Entries of ExecutionNeed (default elements) with following keys can not be migrated : {} ->(only supported \"HwFeatureCategory\" as key is : \"Instructions\")", new Object[]{containerType, containerElementName, defaultElementsbuffer.toString().substring(0, defaultElementsbuffer.length() - 1)});
            }
            parent.removeContent((Content)executionNeedElement);
        }
    }

    private Double getIPCValue(Element extendedElement) {
        Double ipcValue;
        String ipcFeatureElement;
        String puDefinition = HelperUtil.getSingleElementNameFromAttributeOrChildeElement((String)"key", (Element)extendedElement);
        if (puDefinition != null && (ipcFeatureElement = this.cache.getPuDefinitionIPCFeatureMap().get(puDefinition)) != null && (ipcValue = this.cache.getIpcFeatureValueMap().get(ipcFeatureElement)) != null) {
            return ipcValue;
        }
        return 1.0;
    }

    private Element createTicksElementFromNeed(Element valueElement, String newElementName, double ipcValue) {
        if (valueElement != null) {
            String valueType = valueElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (valueType != null && valueType.equals("am:NeedConstant")) {
                Element tc_executionTicksElement = new Element(newElementName);
                Attribute default_executionTicksElement_TypeAttribute = new Attribute("type", "am:DiscreteValueConstant", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                tc_executionTicksElement.getAttributes().add(default_executionTicksElement_TypeAttribute);
                String valueValue = valueElement.getAttributeValue("value");
                if (valueValue != null) {
                    tc_executionTicksElement.getAttributes().add(new Attribute("value", HelperUtils_092_093.getValueAfterApplyingIPC(valueValue, ipcValue)));
                }
                return tc_executionTicksElement;
            }
            if (valueType != null && valueType.equals("am:NeedDeviation")) {
                Element deviationElement = valueElement.getChild("deviation");
                return HelperUtils_092_093.migrateDeviationElement_Containing_LongValue(deviationElement, newElementName, ipcValue);
            }
        }
        return null;
    }

    private PUDefinition_IPCData getHWCache(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                Map map;
                Map cacheMap;
                if (!(c instanceof HWCacheBuilder) || (cacheMap = c.getCacheMap()) == null || cacheMap.size() <= 0 || (map = (Map)cacheMap.values().iterator().next()) == null) continue;
                Object object = map.get("globalCache");
                return (PUDefinition_IPCData)object;
            }
        }
        return null;
    }
}

