/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.core.runtime.SubMonitor;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationHelper.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private MigrationHelper() {
    }

    public static Map<File, MigrationInputFile> populateModels(List<File> inputModelFiles, MigrationSettings migrationSettings, SubMonitor subMonitor) throws Exception {
        HashMap<File, MigrationInputFile> modelFilesMap = new HashMap<File, MigrationInputFile>();
        HashMap<File, Document> loadedDocumentsMapping = new HashMap<File, Document>();
        for (File file : inputModelFiles) {
            Document xmlDoc = HelperUtil.loadFile(file.getAbsolutePath());
            loadedDocumentsMapping.put(file.getCanonicalFile(), xmlDoc);
            if (subMonitor == null) continue;
            subMonitor.worked(1);
        }
        for (File inputFile : loadedDocumentsMapping.keySet()) {
            Document xmlDocument = (Document)loadedDocumentsMapping.get(inputFile);
            MigrationInputFile migModelFile = new MigrationInputFile();
            migModelFile.setFile(inputFile, migrationSettings.getProject());
            migModelFile.setSelectedFile(inputModelFiles.contains(inputFile));
            migModelFile.setDocument(xmlDocument);
            Element rootElement = xmlDocument.getRootElement();
            Namespace namespace = rootElement.getNamespace();
            ModelVersion version = AmaltheaNamespaceRegistry.getModelVersion(namespace);
            if (version != null) {
                migModelFile.setModelVersion(version.getVersion());
            } else {
                migModelFile.setModelVersion("invalid");
            }
            modelFilesMap.put(inputFile, migModelFile);
        }
        return modelFilesMap;
    }

    public static void saveFiles(MigrationSettings settings) throws IOException {
        Set<File> keySet = settings.getMigModelFilesMap().keySet();
        boolean updateFileNames = false;
        if (settings.getInputModelVersion().equals("itea.103") || settings.getInputModelVersion().equals("itea.110")) {
            List<String> allVersions = ModelVersion.getAllSupportedVersions();
            if (!settings.getMigrationModelVersion().equals("itea.103") && !settings.getMigrationModelVersion().equals("itea.110") && allVersions.contains(settings.getMigrationModelVersion())) {
                updateFileNames = true;
            }
        }
        for (File inputFile : keySet) {
            String location;
            int indexOfDot;
            String extension;
            String outputDirectoryLocation = settings.getOutputDirectoryLocation();
            String convertedFileName = inputFile.getName();
            if (updateFileNames && (extension = convertedFileName.substring((indexOfDot = convertedFileName.lastIndexOf(".")) + 1)).startsWith("amxmi") && !extension.equals("amxmi")) {
                convertedFileName = String.valueOf(convertedFileName) + ".amxmi";
            }
            File outputFile = null;
            if (outputDirectoryLocation != null && !outputDirectoryLocation.equals("")) {
                location = String.valueOf(outputDirectoryLocation) + File.separator + convertedFileName;
                HelperUtil.saveFile(settings.getMigModelFilesMap().get(inputFile), location, true, true);
                outputFile = new File(location);
            } else {
                location = String.valueOf(inputFile.getParentFile().getAbsolutePath()) + File.separator + convertedFileName;
                HelperUtil.saveFile(settings.getMigModelFilesMap().get(inputFile), location, true, true);
                outputFile = new File(location);
            }
            LOGGER.info("Migrated model file saved @ : {}", (Object)outputFile.getAbsolutePath());
        }
    }

    public static Map<String, String> generateMigrationSteps(String inputModelVersion, String outputModelVersion) {
        LinkedHashMap<String, String> migStepEntries = new LinkedHashMap<String, String>();
        List<String> versions = ModelVersion.getAllSupportedVersions();
        int inputModelVersionIndex = versions.indexOf(inputModelVersion);
        int outputModelVersionIndex = versions.indexOf(outputModelVersion);
        if (inputModelVersionIndex != -1 && outputModelVersionIndex != -1) {
            int i = inputModelVersionIndex;
            while (i <= outputModelVersionIndex && i + 1 <= outputModelVersionIndex) {
                migStepEntries.put(versions.get(i), versions.get(i + 1));
                ++i;
            }
        }
        return migStepEntries;
    }

    public static boolean isInputModelVersionValid(MigrationSettings migrationSettings) {
        List<MigrationInputFile> modelsWithLegacyVersionInfo = MigrationHelper.getInputModelsOfLegacyVersions(migrationSettings);
        List<MigrationInputFile> modelsWithInvalidVersionInfo = MigrationHelper.getModelsWithInvalidVersionInfo(migrationSettings);
        if (modelsWithLegacyVersionInfo.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("Can not migrate legacy Amalthea models of versions : itea.103 or itea.110 or itea.111");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("From APP4MC 0.9.3, support for migrating legacy model versions (itea.103, itea.110, itea.111) is removed");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("** Legacy model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getFile().getAbsolutePath()).append(" Version: ").append(migrationFile.getModelVersion());
                builder.append(LINE_SEPARATOR);
                builder.append(" -------- > Version: ").append(migrationFile.getModelVersion());
            }
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            builder.append("Use one of the previous version of APP4MC (till 0.9.2) for migrating these legacy Amalthea models to regular versions (0.7.0 and above)");
            throw new MigrationException(builder.toString());
        }
        if (modelsWithInvalidVersionInfo.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("Invalid model versions found for the below files ->");
            builder.append(LINE_SEPARATOR);
            builder.append(LINE_SEPARATOR);
            for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                builder.append(migrationFile.getFile().getAbsolutePath());
                builder.append(LINE_SEPARATOR);
            }
            throw new MigrationException(builder.toString());
        }
        boolean inputModelVersionEqual = true;
        String inputModelVersion = null;
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            if (inputModelVersion == null) {
                inputModelVersion = migModelFile.getModelVersion();
                continue;
            }
            if (inputModelVersion.equals(migModelFile.getModelVersion())) continue;
            migModelFile.setVersionDifferent(true);
            inputModelVersionEqual = false;
        }
        if (inputModelVersionEqual) {
            migrationSettings.setInputModelVersion(inputModelVersion);
        }
        return inputModelVersionEqual;
    }

    private static List<MigrationInputFile> getInputModelsOfLegacyVersions(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (inputModelVersion == null || !inputModelVersion.equals("itea.103") && !inputModelVersion.equals("itea.110") && !inputModelVersion.equals("itea.111")) continue;
            list.add(migModelFile);
        }
        return list;
    }

    private static List<MigrationInputFile> getModelsWithInvalidVersionInfo(MigrationSettings migrationSettings) {
        ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
        for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
            String inputModelVersion = migModelFile.getModelVersion();
            if (ModelVersion.isValidVersion(inputModelVersion)) continue;
            list.add(migModelFile);
        }
        return list;
    }

    public static boolean createBackupFile(MigrationInputFile migrationInputFile) {
        String newFileName = MigrationHelper.getBackupFileName(migrationInputFile);
        try {
            String filebackupName = String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName;
            Files.copy(migrationInputFile.getFile().toPath(), new File(filebackupName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Original model file saved as {}", (Object)filebackupName);
            if (new File(filebackupName).exists()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String getBackupFileName(MigrationInputFile migrationInputFile) {
        String fileName = migrationInputFile.getFile().getName();
        String newFileName = fileName.substring(0, fileName.lastIndexOf("."));
        String suffixString = "_" + migrationInputFile.getModelVersion();
        String fileExtension = ".amxmi";
        newFileName = String.valueOf(newFileName) + suffixString + fileExtension;
        if (new File(String.valueOf(migrationInputFile.getFile().getParent()) + File.separator + newFileName).exists()) {
            newFileName = newFileName.replace(String.valueOf(suffixString) + fileExtension, String.valueOf(suffixString) + suffixString + fileExtension);
        }
        return newFileName;
    }
}

