/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.base.IModelMigration;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(factory="org.eclipse.app4mc.amalthea.modelmigration.factory")
public class ModelMigration
implements IModelMigration {
    private String inputModelVersion;
    private String outputModelVersion;
    @Reference
    List<ICache> caches;
    @Reference(target="(component.factory=org.eclipse.app4mc.amalthea.namespaceconverter.factory)")
    ComponentFactory factory;
    @Reference
    List<IConverter> converter;
    @Reference
    List<IPostProcessor> postProcessor;

    @Activate
    void activate(Map<String, Object> properties) {
        this.inputModelVersion = properties.get("input_model_version").toString();
        this.outputModelVersion = properties.get("output_model_version").toString();
    }

    @Override
    public List<ICache> getCaches() {
        return Collections.unmodifiableList(this.caches);
    }

    @Override
    public List<IConverter> getConverter() {
        ArrayList<IConverter> result = new ArrayList<IConverter>(this.converter);
        Collections.reverse(result);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("input_model_version", this.getInputModelVersion());
        ((Dictionary)properties).put("output_model_version", this.getOutputModelVersion());
        ComponentInstance newInstance = this.factory.newInstance(properties);
        IConverter namespaceConverter = (IConverter)newInstance.getInstance();
        result.add(namespaceConverter);
        return result;
    }

    @Override
    public List<IPostProcessor> getPostProcessor() {
        return Collections.unmodifiableList(this.postProcessor);
    }

    @Override
    public String getInputModelVersion() {
        return this.inputModelVersion;
    }

    @Override
    public String getOutputModelVersion() {
        return this.outputModelVersion;
    }
}

