/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2"}, service={IConverter.class})
public class CommonElementsConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonElementsConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.1 to 0.7.2 : Executing Common Elements converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateCommonElements(rootElement);
    }

    private void updateCommonElements(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./componentsModel/tags");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel/tags");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tags");
        List tagElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (tagElements.size() > 0) {
            LOGGER.warn("Tag element's from Components Model, HW Model, SW Model are shifted to CommonElements model");
            Element commonElements = rootElement.getChild("commonElements");
            if (commonElements == null) {
                commonElements = new Element("commonElements");
                rootElement.addContent((Content)commonElements);
            }
            for (Element tagElement : tagElements) {
                Element parentElement = tagElement.getParentElement();
                parentElement.removeContent((Content)tagElement);
                commonElements.addContent((Content)tagElement);
            }
        }
    }
}

