/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.utils;

import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelperUtils_092_093 {
    public static final Logger LOGGER = LoggerFactory.getLogger(HelperUtils_092_093.class);

    private HelperUtils_092_093() {
    }

    public static Element migrateDeviationElement_Containing_LongValue(Element oldDeviationElement, String newElementName, double ipcValue) {
        Element oldDistributionElement;
        String value;
        Element upperBound;
        String value2;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild("lowerBound");
        if (lowerBound != null && (value2 = lowerBound.getAttributeValue("value")) != null) {
            newDeviationElement.setAttribute(new Attribute("lowerBound", HelperUtils_092_093.getValueAfterApplyingIPC(value2, ipcValue)));
        }
        if ((upperBound = oldDeviationElement.getChild("upperBound")) != null && (value = upperBound.getAttributeValue("value")) != null) {
            newDeviationElement.setAttribute(new Attribute("upperBound", HelperUtils_092_093.getValueAfterApplyingIPC(value, ipcValue)));
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue("alpha");
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute("alpha", alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue("beta")) != null) {
                newDeviationElement.setAttribute(new Attribute("beta", beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            String sd;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value");
            if (mean != null) {
                newDeviationElement.setAttribute(new Attribute("mean", HelperUtils_092_093.getValueAfterApplyingIPC(mean, ipcValue)));
            }
            if ((sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"sd", (String)"value")) != null) {
                newDeviationElement.setAttribute(new Attribute("sd", sd));
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            String mean;
            HelperUtils_092_093.setType(newDeviationElement, "am:DiscreteValueWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            if ((mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value")) != null) {
                newDeviationElement.setAttribute(new Attribute("average", HelperUtils_092_093.getValueAfterApplyingIPC(mean, ipcValue)));
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            LOGGER.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described");
            return null;
        }
        return newDeviationElement;
    }

    public static Element migrateDeviationElement_Containing_DoubleValue(Element oldDeviationElement, String newElementName) {
        Element oldDistributionElement;
        String value;
        Element upperBound;
        String value2;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild("lowerBound");
        if (lowerBound != null && (value2 = lowerBound.getAttributeValue("value")) != null) {
            newDeviationElement.setAttribute(new Attribute("lowerBound", value2));
        }
        if ((upperBound = oldDeviationElement.getChild("upperBound")) != null && (value = upperBound.getAttributeValue("value")) != null) {
            newDeviationElement.setAttribute(new Attribute("upperBound", value));
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue("alpha");
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute("alpha", alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue("beta")) != null) {
                newDeviationElement.setAttribute(new Attribute("beta", beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            String sd;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value");
            if (mean != null) {
                newDeviationElement.setAttribute(new Attribute("mean", mean));
            }
            if ((sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"sd", (String)"value")) != null) {
                newDeviationElement.setAttribute(new Attribute("sd", sd));
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            String mean;
            HelperUtils_092_093.setType(newDeviationElement, "am:ContinuousValueWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            if ((mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value")) != null) {
                newDeviationElement.setAttribute(new Attribute("average", mean));
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            LOGGER.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described");
            return null;
        }
        return newDeviationElement;
    }

    public static Element migrateDeviationElement_Containing_TimeValue(Element oldDeviationElement, String newElementName) {
        Element oldDistributionElement;
        Element upperBound;
        if (oldDeviationElement == null) {
            return null;
        }
        Element newDeviationElement = new Element(newElementName);
        Element lowerBound = oldDeviationElement.getChild("lowerBound");
        if (lowerBound != null) {
            String unitString;
            Element lowerBoundElement = new Element("lowerBound");
            newDeviationElement.addContent((Content)lowerBoundElement);
            String valueString = lowerBound.getAttributeValue("value");
            if (valueString != null) {
                lowerBoundElement.setAttribute("value", valueString);
            }
            if ((unitString = lowerBound.getAttributeValue("unit")) != null) {
                lowerBoundElement.setAttribute("unit", unitString);
            }
        }
        if ((upperBound = oldDeviationElement.getChild("upperBound")) != null) {
            String unitString;
            Element upperBoundElement = new Element("upperBound");
            newDeviationElement.addContent((Content)upperBoundElement);
            String valueString = upperBound.getAttributeValue("value");
            if (valueString != null) {
                upperBoundElement.setAttribute("value", valueString);
            }
            if ((unitString = upperBound.getAttributeValue("unit")) != null) {
                upperBoundElement.setAttribute("unit", unitString);
            }
        }
        if ((oldDistributionElement = oldDeviationElement.getChild("distribution")) == null) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBoundaries");
            return newDeviationElement;
        }
        String oldDistributionType = oldDistributionElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        if (oldDistributionType.equals("am:BetaDistribution")) {
            String beta;
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBetaDistribution");
            String alpha = oldDistributionElement.getAttributeValue("alpha");
            if (alpha != null) {
                newDeviationElement.setAttribute(new Attribute("alpha", alpha));
            }
            if ((beta = oldDistributionElement.getAttributeValue("beta")) != null) {
                newDeviationElement.setAttribute(new Attribute("beta", beta));
            }
        } else if (oldDistributionType.equals("am:Boundaries")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeBoundaries");
            String samplingType = oldDistributionElement.getAttributeValue("samplingType");
            if (samplingType != null) {
                newDeviationElement.setAttribute(new Attribute("samplingType", samplingType));
            }
        } else if (oldDistributionType.equals("am:GaussDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeGaussDistribution");
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value");
            String mean_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"unit");
            String sd = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"sd", (String)"value");
            String sd_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"sd", (String)"unit");
            if (mean != null) {
                Element meanElement = new Element("mean");
                meanElement.setAttribute("value", mean);
                if (mean_unit != null) {
                    meanElement.setAttribute("unit", mean_unit);
                }
                newDeviationElement.addContent((Content)meanElement);
            }
            if (sd != null) {
                Element sdElement = new Element("sd");
                sdElement.setAttribute("value", sd);
                if (sd_unit != null) {
                    sdElement.setAttribute("unit", sd_unit);
                }
                newDeviationElement.addContent((Content)sdElement);
            }
        } else if (oldDistributionType.equals("am:UniformDistribution")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeUniformDistribution");
        } else if (oldDistributionType.equals("am:WeibullEstimators")) {
            HelperUtils_092_093.setType(newDeviationElement, "am:TimeWeibullEstimatorsDistribution");
            String pRemainPromille = oldDistributionElement.getAttributeValue("pRemainPromille");
            if (pRemainPromille != null) {
                newDeviationElement.setAttribute(new Attribute("pRemainPromille", pRemainPromille));
            }
            String mean = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"value");
            String mean_unit = HelperUtil.getValueFromChildElement((Element)oldDistributionElement, (String)"mean", (String)"unit");
            if (mean != null) {
                Element averageElement = new Element("average");
                averageElement.setAttribute(new Attribute("value", mean));
                if (mean_unit != null) {
                    averageElement.setAttribute(new Attribute("unit", mean_unit));
                }
                newDeviationElement.addContent((Content)averageElement);
            }
        } else if (oldDistributionType.equals("am:WeibullParameters")) {
            LOGGER.error("Deviation with \"WeibullParameters\" as distribution can not be migrated as the semantics of \"WeibullParameters\" were not clearly described");
            return null;
        }
        return newDeviationElement;
    }

    public static String getValueAfterApplyingIPC(String value, double ipcValue) {
        if (ipcValue != 0.0) {
            try {
                Double result = Double.parseDouble(value) / ipcValue;
                return String.valueOf(result.longValue());
            }
            catch (Exception e) {
                LOGGER.error("error on IPC value conversion", (Throwable)e);
            }
        }
        return value;
    }

    private static void setType(Element deviation, String distributionType) {
        Attribute value_TypeAttribute = new Attribute("type", distributionType, AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        deviation.getAttributes().add(value_TypeAttribute);
    }
}

