/**
 ********************************************************************************
 * Copyright (c) 2015-2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */

package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;

import org.jdom2.Document;

public class MigrationInputFile {

	private String modelVersion = "";

	private boolean isSelectedFile;

	private File file;

	private String projectRelativePath;

	private Document document;

	/*- this field is used to mark ModelFiles, if they have different versions than other files */
	private boolean isVersionDifferent;

	public String getModelVersion() {
		return this.modelVersion;
	}

	public void setModelVersion(String modelVersion) {
		this.modelVersion = modelVersion;
	}

	public boolean isSelectedFile() {
		return this.isSelectedFile;
	}

	public void setSelectedFile(boolean isSelectedFile) {
		this.isSelectedFile = isSelectedFile;
	}

	public File getFile() {
		return this.file;
	}

	public void setFile(File file, File project) {
		this.file = file;
		this.projectRelativePath = project.toURI().relativize(file.toURI()).getPath();
	}

	public String getProjectRelativePath() {
		return this.projectRelativePath;
	}

	public Document getDocument() {
		return this.document;
	}

	public void setDocument(Document document) {
		this.document = document;
	}

	public boolean isVersionDifferent() {
		return this.isVersionDifferent;
	}

	public void setVersionDifferent(boolean isVersionDifferent) {
		this.isVersionDifferent = isVersionDifferent;
	}
}
