/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.2", "output_model_version=0.8.0"}, service={IConverter.class})
public class OSConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.2 to 0.8.0 : Executing OS converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.move_OsDataConsistency_Element(rootElement);
    }

    private void move_OsDataConsistency_Element(Element rootElement) {
        List osDataConsistencyElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/osDataConsistency", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        List operatingSystemElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./osModel/operatingSystems", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (osDataConsistencyElements.size() > 0) {
            Element osDataConsistencyElement = (Element)osDataConsistencyElements.get(0);
            for (Element operatingSystemElement : operatingSystemElements) {
                Element clone_osDataConsistencyElement = osDataConsistencyElement.clone();
                operatingSystemElement.addContent((Content)clone_osDataConsistencyElement);
            }
            LOGGER.warn("OsDataConsistency element is removed from OsModel, and is added (cloned content) to each OperatingSystem element (which is part of corresponding OsModel).");
            osDataConsistencyElement.getParentElement().removeContent((Content)osDataConsistencyElement);
        }
    }
}

