/**
 ********************************************************************************
 * Copyright (c) 2019 Robert Bosch GmbH and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 ********************************************************************************
 */
package org.eclipse.app4mc.amalthea.converters.log4j.configuration;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/**
 * Custom Log4j appender that forwards log statements to the Eclipse logging mechanism.
 */
public class EclipseLogAppender extends AppenderSkeleton {

	private int getStatus(final LoggingEvent event) {
		final Level level = event.getLevel();

		int status = IStatus.INFO;

		if (level == Level.ERROR) {
			status = IStatus.ERROR;
		}
		else if (level == Level.INFO) {
			status = IStatus.INFO;
		}
		else if (level == Level.WARN) {
			status = IStatus.WARNING;
		}
		else if (level == Level.FATAL) {
			status = IStatus.ERROR;
		}
		return status;
	}

	@Override
	protected void append(final LoggingEvent event) {

		final Object messageObject = event.getMessage();
		final ThrowableInformation throwableInformation = event.getThrowableInformation();
		final int status = getStatus(event);

		Bundle bundle = FrameworkUtil.getBundle(getClass());
		if (bundle != null) {
			if (throwableInformation != null) {
				Platform.getLog(bundle).log(new Status(status, bundle.getSymbolicName(),
								messageObject != null ? messageObject.toString() : "",
								throwableInformation.getThrowable()));
			}
			else {
				Platform.getLog(bundle).log(new Status(status, bundle.getSymbolicName(),
						messageObject != null ? messageObject.toString() : ""));
			}
		}
	}

	@Override
	public void close() {
	}

	@Override
	public boolean requiresLayout() {
		return false;
	}

}
