/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.MigrationJobChangeListener;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.app4mc.amalthea.converters.ui.providers.MigrationInputDataProvider;
import org.eclipse.app4mc.amalthea.converters.ui.providers.StyledLabelProvider;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ModelMigrationDialog
extends Dialog {
    private MigrationProcessor migrationProcessor;
    private MigrationSettings migrationSettings;
    private IProject iProject;

    public ModelMigrationDialog(Shell parentShell, MigrationProcessor migrationProcessor, MigrationSettings settings, IProject iProject) {
        super(parentShell);
        this.setShellStyle(67696);
        if (migrationProcessor == null) {
            throw new IllegalStateException("MigrationProcessor cannot be null");
        }
        this.migrationProcessor = migrationProcessor;
        this.migrationSettings = settings == null ? new MigrationSettings() : settings;
        this.iProject = iProject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("AMALTHEA Model Migration");
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("AMALTHEA Model Migration");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)parentComposite.getLayout();
        gridLayout.numColumns = 1;
        Group grpInitialModel = new Group(parentComposite, 0);
        grpInitialModel.setText("AMALTHEA Models");
        grpInitialModel.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)grpInitialModel);
        Composite tableComposite = this.createFileTableViewer((Composite)grpInitialModel);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)tableComposite);
        Label lblInputModelsIdentificationInfo = new Label((Composite)grpInitialModel, 0);
        lblInputModelsIdentificationInfo.setText("* Blue color: Selected Model files. Black color: Model scope files");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(false, false).span(2, 1).applyTo((Control)lblInputModelsIdentificationInfo);
        Label lblModelVersion = new Label((Composite)grpInitialModel, 0);
        lblModelVersion.setText("Model Version: ");
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)lblModelVersion);
        Text txtInputModelVersion = new Text((Composite)grpInitialModel, 2048);
        txtInputModelVersion.setEnabled(false);
        txtInputModelVersion.setEditable(false);
        txtInputModelVersion.setText(this.migrationSettings.getInputModelVersion());
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)txtInputModelVersion);
        Group grpMigrationModels = new Group(parentComposite, 0);
        grpMigrationModels.setText("Migration details");
        grpMigrationModels.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)grpMigrationModels);
        Label migModelVersionText = new Label((Composite)grpMigrationModels, 0);
        migModelVersionText.setText("Model Version");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)migModelVersionText);
        final Combo migModelVersionCombo = new Combo((Composite)grpMigrationModels, 8);
        migModelVersionCombo.select(0);
        GridDataFactory.swtDefaults().grab(false, false).span(2, 1).applyTo((Control)migModelVersionCombo);
        String version = this.migrationSettings.getInputModelVersion();
        if (version != null) {
            List allSupportedVersions = ModelVersion.getAllSupportedVersions();
            int totalVersionSize = allSupportedVersions.size();
            int startIndex = allSupportedVersions.indexOf(version);
            if (startIndex != -1) {
                List subList = allSupportedVersions.subList(startIndex + 1, totalVersionSize);
                Collections.reverse(subList);
                migModelVersionCombo.setItems(subList.toArray(new String[0]));
                migModelVersionCombo.select(0);
            }
        }
        Label lblOutputDirectory = new Label((Composite)grpMigrationModels, 0);
        lblOutputDirectory.setText("Output directory");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)lblOutputDirectory);
        final Text txtOutputDirectory = new Text((Composite)grpMigrationModels, 2048);
        txtOutputDirectory.setEditable(false);
        txtOutputDirectory.setTouchEnabled(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)txtOutputDirectory);
        migModelVersionCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String selection_outputModelVersion = migModelVersionCombo.getText();
                if (selection_outputModelVersion != null && selection_outputModelVersion.length() > 0) {
                    ModelMigrationDialog.this.migrationSettings.setMigrationModelVersion(selection_outputModelVersion);
                }
            }
        });
        Button btnBrowse = new Button((Composite)grpMigrationModels, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(e.display.getActiveShell());
                dialog.setFilterPath(ModelMigrationDialog.this.migrationSettings.getProject().getAbsolutePath());
                String selectedPath = dialog.open();
                if (selectedPath != null) {
                    ModelMigrationDialog.this.migrationSettings.setOutputDirectoryLocation(selectedPath);
                    txtOutputDirectory.setText(selectedPath);
                }
            }
        });
        btnBrowse.setText("Browse...");
        GridDataFactory.swtDefaults().grab(false, false).applyTo((Control)btnBrowse);
        this.initDataBindings(txtOutputDirectory, migModelVersionCombo);
        return parentComposite;
    }

    private Composite createFileTableViewer(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        TableViewer tableViewer = new TableViewer(tableComposite, 66304);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.getHorizontalBar().setEnabled(true);
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText("Relative file paths");
        tableColumnLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
        MigrationInputDataProvider provider = new MigrationInputDataProvider(new StyledLabelProvider());
        tableViewer.setContentProvider((IContentProvider)provider);
        tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.migrationSettings.getMigModelFiles().sort(new Comparator<MigrationInputFile>(){

            @Override
            public int compare(MigrationInputFile o1, MigrationInputFile o2) {
                if (o1.isSelectedFile()) {
                    return -1;
                }
                return 1;
            }
        });
        tableViewer.setInput((Object)this.migrationSettings.getMigModelFiles());
        return tableComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button migrateModelsButton = this.createButton(parent, 0, "Migrate Models", true);
        migrateModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelMigrationJob migrationJob = new ModelMigrationJob("AMALTHEA Model Migration", ModelMigrationDialog.this.migrationProcessor, ModelMigrationDialog.this.migrationSettings);
                migrationJob.setUser(true);
                migrationJob.schedule();
                migrationJob.addJobChangeListener((IJobChangeListener)new MigrationJobChangeListener(ModelMigrationDialog.this.getShell(), ModelMigrationDialog.this.iProject));
            }
        });
        Button cancelMigrationButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancelMigrationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Job.getJobManager().cancel((Object)"AMALTHEA_MODEL_MIGRATION");
            }
        });
    }

    protected DataBindingContext initDataBindings(Text txtOutputDirectory, Combo migModelVersionCombo) {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtOutputDirectoryObserveWidget = WidgetProperties.text((int)24).observe((Widget)txtOutputDirectory);
        ISWTObservableValue observeSelectionMig_model_version_comboObserveWidget = WidgetProperties.selection().observe((Widget)migModelVersionCombo);
        IObservableValue outputDirectoryLocationMigDataModelObserveValue = PojoProperties.value((String)"outputDirectoryLocation").observe((Object)this.migrationSettings);
        bindingContext.bindValue((IObservableValue)observeTextTxtOutputDirectoryObserveWidget, outputDirectoryLocationMigDataModelObserveValue, null, null);
        IObservableValue migrationModelVersionMigrationSettingsObserveValue = PojoProperties.value((String)"migrationModelVersion").observe((Object)this.migrationSettings);
        bindingContext.bindValue((IObservableValue)observeSelectionMig_model_version_comboObserveWidget, migrationModelVersionMigrationSettingsObserveValue, null, null);
        return bindingContext;
    }
}

