/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.providers;

import java.io.File;
import java.util.List;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationInputDataProvider
extends DelegatingStyledCellLabelProvider
implements IStructuredContentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationInputDataProvider.class);

    public MigrationInputDataProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        super(labelProvider);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return new Object[]{inputElement};
    }

    public StyledString getStyledText(Object element) {
        MigrationInputFile migModelFile;
        File file;
        if (element instanceof MigrationInputFile && (file = (migModelFile = (MigrationInputFile)element).getFile()) != null) {
            try {
                String path = migModelFile.getProjectRelativePath();
                if (migModelFile.isSelectedFile()) {
                    return new StyledString(path, (StyledString.Styler)new BoldFontStyler());
                }
                return new StyledString(path);
            }
            catch (Exception e) {
                LOGGER.warn("unable to build the relative path for file : {}", (Object)file.getAbsolutePath(), (Object)e);
                return new StyledString(file.getAbsolutePath());
            }
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    class BoldFontStyler
    extends StyledString.Styler {
        BoldFontStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = Display.getCurrent().getSystemColor(9);
        }
    }
}

