/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.2 to 0.9.3 : Executing Hw converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_Latency(rootElement);
    }

    private void update_Latency(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./hwModel//accessLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//readLatency");
        xpathBuffer.append("|");
        xpathBuffer.append("./hwModel//writeLatency");
        List latencyElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element latencyElement : latencyElements) {
            Attribute typeAttribute = latencyElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (typeAttribute == null) continue;
            String type = typeAttribute.getValue();
            if (type.equals("am:LatencyConstant")) {
                type = "am:DiscreteValueConstant";
                typeAttribute.setValue(type);
                Attribute cyclesAttribute = latencyElement.getAttribute("cycles");
                if (cyclesAttribute == null) continue;
                cyclesAttribute.setName("value");
                continue;
            }
            if (!type.equals("am:LatencyDeviation")) continue;
            String elementName = latencyElement.getName();
            Parent parentElement = latencyElement.getParent();
            int indexOf = parentElement.indexOf((Content)latencyElement);
            Element migratedElement = HelperUtils_092_093.migrateDeviationElement_Containing_LongValue(latencyElement.getChild("cycles"), elementName, 1.0);
            parentElement.removeContent((Content)latencyElement);
            if (migratedElement == null) continue;
            parentElement.addContent(indexOf, (Content)migratedElement);
        }
    }
}

