/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters094.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.3", "output_model_version=0.9.4"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.3 to 0.9.4 : Executing Hw converter for model file : {}", (Object)targetFile.getName());
        Document document = fileName_documentsMap.get(targetFile);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.update_portInterface(rootElement);
    }

    private void update_portInterface(Element rootElement) {
        String xpath = "./hwModel/structures//ports[@portInterface=\"ABH\"]";
        List portInterfaceElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./hwModel/structures//ports[@portInterface=\"ABH\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._094, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element portInterfaceElement : portInterfaceElements) {
            Attribute portInterfaceAttribute = portInterfaceElement.getAttribute("portInterface");
            portInterfaceAttribute.setValue("AHB");
        }
    }
}

