/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.ModelMigration;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jdom2.Document;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MigrationProcessor.class})
public class MigrationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationProcessor.class);
    private static final String OUTPUT_DIRECTORY_KEY = "APP4MC_MIGRATION_OUTPUT_DIRECTORY";
    private static final String NEWLINE = System.getProperty("line.separator");
    @Reference(target="(component.factory=org.eclipse.app4mc.amalthea.modelmigration.factory)")
    ComponentFactory<ModelMigration> factory;

    public int execute(MigrationSettings settings, IProgressMonitor monitor) {
        System.setProperty(OUTPUT_DIRECTORY_KEY, settings.getOutputDirectoryLocation());
        try {
            Map<String, String> migStepEntries;
            if (monitor != null) {
                monitor.setTaskName("Collecting information for intermediate migration steps");
            }
            if ((migStepEntries = MigrationHelper.generateMigrationSteps(settings.getInputModelVersion(), settings.getMigrationModelVersion())).size() == 0) {
                LOGGER.error("Migration not supported for the selected model versions. \nInput Model version : \"{}\" Output Model Version : \"{}\"", (Object)settings.getInputModelVersion(), (Object)settings.getMigrationModelVersion());
                return 20;
            }
            SubMonitor subMonitor = monitor != null ? SubMonitor.convert((IProgressMonitor)monitor, (int)(migStepEntries.size() + 1)) : null;
            Map<File, Document> fileDocumentMapping = settings.getMigModelFilesMap();
            StringBuilder builder = new StringBuilder();
            builder.append(NEWLINE);
            builder.append("***************************************************************************************************************************************");
            builder.append(NEWLINE);
            builder.append("\t\t Starting model migration for the following AMALTHEA models: ");
            builder.append(NEWLINE);
            for (File modelFile : fileDocumentMapping.keySet()) {
                builder.append("\t\t -- ");
                builder.append(modelFile.getAbsolutePath());
                builder.append(NEWLINE);
            }
            builder.append(NEWLINE);
            builder.append("***************************************************************************************************************************************");
            builder.append(NEWLINE);
            LOGGER.info(builder.toString());
            boolean conversionPerformed = false;
            String currentModelVersion = settings.getInputModelVersion();
            while (!currentModelVersion.equals(settings.getMigrationModelVersion())) {
                if (subMonitor != null && subMonitor.isCanceled()) {
                    return 40;
                }
                Hashtable<String, String> properties = new Hashtable<String, String>();
                String inputFilterExp = "(input_model_version=" + currentModelVersion + ")";
                String inputOuputFilterExpression = "(&(input_model_version=" + currentModelVersion + ")(output_model_version=" + migStepEntries.get(currentModelVersion) + "))";
                ((Dictionary)properties).put("input_model_version", currentModelVersion);
                ((Dictionary)properties).put("output_model_version", migStepEntries.get(currentModelVersion));
                ((Dictionary)properties).put("caches.target", inputFilterExp);
                ((Dictionary)properties).put("converter.target", inputOuputFilterExpression);
                ((Dictionary)properties).put("postProcessor.target", inputOuputFilterExpression);
                ComponentInstance newInstance = this.factory.newInstance(properties);
                ModelMigration modelMigration = (ModelMigration)newInstance.getInstance();
                String outputModelVersion = modelMigration.getOutputModelVersion();
                if (subMonitor != null) {
                    subMonitor.setTaskName("Migrating AMALTHEA models from : " + currentModelVersion + " to " + outputModelVersion);
                }
                LOGGER.info("=========== START: Migrating AMALTHEA models from : {} to {} ========== ", (Object)currentModelVersion, (Object)outputModelVersion);
                LOGGER.trace("Start : Building cache for AMALTHEA models present in : {}", (Object)currentModelVersion);
                long st = System.currentTimeMillis();
                for (ICache cache : modelMigration.getCaches()) {
                    cache.clearCacheMap();
                    cache.buildCache(fileDocumentMapping);
                }
                long end = System.currentTimeMillis();
                LOGGER.trace("End : Building cache for AMALTHEA models present in : {}", (Object)currentModelVersion);
                LOGGER.trace("Total time taken to build cache for {} models: {} milli seconds", (Object)currentModelVersion, (Object)(end - st));
                for (IConverter converter : modelMigration.getConverter()) {
                    for (File file : fileDocumentMapping.keySet()) {
                        converter.convert(file, fileDocumentMapping, modelMigration.getCaches());
                        conversionPerformed = true;
                    }
                }
                for (IPostProcessor postProcessor : modelMigration.getPostProcessor()) {
                    postProcessor.process(fileDocumentMapping);
                }
                LOGGER.info("=========== END: Migrating AMALTHEA models from : {} to {}  =========== \n\r", (Object)currentModelVersion, (Object)outputModelVersion);
                if (currentModelVersion.equals(outputModelVersion)) {
                    outputModelVersion = migStepEntries.get(currentModelVersion);
                }
                currentModelVersion = outputModelVersion;
                for (ICache cache : modelMigration.getCaches()) {
                    cache.clearCacheMap();
                }
                if (subMonitor == null) continue;
                subMonitor.worked(1);
            }
            if (conversionPerformed) {
                if (subMonitor != null) {
                    subMonitor.setTaskName("Saving migrated AMALTHEA model files ");
                }
                try {
                    MigrationHelper.saveFiles(settings);
                }
                catch (IOException e) {
                    throw new MigrationException("Error on saving migrated files.", e);
                }
            }
            if (subMonitor != null) {
                subMonitor.worked(1);
            }
            return 10;
        }
        finally {
            System.clearProperty(OUTPUT_DIRECTORY_KEY);
            LOGGER.info("Migration session finished");
        }
    }
}

