/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ModelLoaderJob
extends Job {
    private final MigrationSettings migrationSettings;
    private final List<File> inputModels;

    public ModelLoaderJob(String name, MigrationSettings migrationSettings, List<File> inputModels) {
        super(name);
        this.migrationSettings = migrationSettings;
        this.inputModels = inputModels;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int size = this.inputModels.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        subMonitor.setTaskName("Loading selected model files ...");
        try {
            Map modelFilesMap = MigrationHelper.populateModels(this.inputModels, (MigrationSettings)this.migrationSettings);
            this.migrationSettings.getMigModelFiles().addAll(modelFilesMap.values());
        }
        catch (Exception e1) {
            Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
            if (bundle != null) {
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundle.getSymbolicName(), 1, "Failed to load model files", (Throwable)e1));
            }
            return new Status(8, "unknown", 1, e1.getMessage(), (Throwable)e1);
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals("AMALTHEA_MODEL_MIGRATION")) {
            return true;
        }
        return super.belongsTo(family);
    }
}

