/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.postprocessor;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Namespace;

public class FileNameUpdationProcessor
implements IPostProcessor {
    @Override
    public void process(Map<File, Document> fileName_documentsMap) {
        for (Map.Entry<File, Document> entry : fileName_documentsMap.entrySet()) {
            File inputFile = entry.getKey();
            Document document = entry.getValue();
            List<Attribute> hrefs = HelperUtil.getXpathResult(document.getRootElement(), ".//@href", Attribute.class, new Namespace[0]);
            for (Attribute attribute : hrefs) {
                String extension;
                String attributeValue = attribute.getValue();
                int indexOfHash = attributeValue.lastIndexOf(35);
                if (indexOfHash == -1 || indexOfHash + 1 >= attributeValue.length()) continue;
                String refRelativePath = attributeValue.substring(0, indexOfHash);
                int lastIndex = refRelativePath.lastIndexOf(47);
                String refFileName = "";
                if (lastIndex == -1) {
                    refFileName = refRelativePath;
                } else if (lastIndex != -1 && lastIndex + 1 < refRelativePath.length()) {
                    refFileName = refRelativePath.substring(lastIndex + 1);
                }
                if (refFileName.length() <= 0) continue;
                int indexOfDot = refFileName.indexOf(46);
                if (indexOfDot != -1 && (extension = refFileName.substring(indexOfDot + 1)).startsWith("amxmi") && !extension.equals("amxmi")) {
                    refFileName = String.valueOf(refFileName) + ".amxmi";
                }
                String attributeValue_part2 = attributeValue.substring(indexOfHash + 1);
                attribute.setValue(String.valueOf(refFileName) + "#" + attributeValue_part2);
            }
        }
    }
}

