/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheBuilder;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.0", "output_model_version=0.7.1"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwConverter.class);
    protected SectionRunnableLabelCacheBuilder cache;
    private Map<File, Document> fileDocumentMapping;
    private File targetFile;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.0 to 0.7.1 : Executing Sw converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getSectionRunnableLabelCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("SectionRunnableLabelCache is not built and Object of it is not available in Converters");
        }
        this.fileDocumentMapping = fileDocumentMapping;
        this.targetFile = targetFile;
        Document root = fileDocumentMapping.get(this.targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_DataSize(rootElement);
        this.update_MemoryElements_With_Section_Info(rootElement);
        this.update_Section(rootElement);
        this.remove_SectionMapping_and_SectionMappingConstraint(rootElement);
        this.update_ModeSwitch(rootElement);
    }

    private void update_ModeSwitch(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/tasks/callGraph//graphEntries");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/callGraph//graphEntries");
        List graphEntryBaseElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element graphEntryBaseElement : graphEntryBaseElements) {
            String graphEntryBaseObjectType;
            if (!graphEntryBaseElement.getParentElement().getName().equals("callGraph")) {
                graphEntryBaseElement.setName("items");
            }
            if ((graphEntryBaseObjectType = graphEntryBaseElement.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) == null || !graphEntryBaseObjectType.equals("am:ModeSwitch")) continue;
            List entriesElements = graphEntryBaseElement.getChildren("entries");
            boolean isDefaultFound = false;
            for (Element entriesElement : entriesElements) {
                Attribute valueAttribute;
                Attribute defaultAttribute = entriesElement.getAttribute("default");
                if (defaultAttribute != null) {
                    if (!isDefaultFound) {
                        isDefaultFound = true;
                        entriesElement.setName("defaultEntry");
                        entriesElement.removeAttribute("value");
                        entriesElement.removeChild("value");
                    }
                    entriesElement.removeAttribute("default");
                }
                if ((valueAttribute = entriesElement.getAttribute("value")) != null) {
                    valueAttribute.setName("values");
                    continue;
                }
                Element valueElement = entriesElement.getChild("value");
                if (valueElement == null) continue;
                valueElement.setName("values");
            }
        }
    }

    private void remove_SectionMapping_and_SectionMappingConstraint(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./mappingModel/mapping[@xsi:type=\"am:SectionMapping\"]");
        xpathBuffer.append("|");
        xpathBuffer.append("./propertyConstraintsModel/mappingConstraints[@xsi:type=\"am:SectionMappingConstraint\"]");
        List elements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element sectionMappingElement : elements) {
            sectionMappingElement.getParent().removeContent((Content)sectionMappingElement);
        }
    }

    private void update_Section(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/sections");
        List sectionElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element element : sectionElements) {
            element.removeChildren("size");
            element.removeChildren("labels");
            element.removeChildren("runEntities");
            element.removeAttribute("labels");
            element.removeAttribute("runEntities");
        }
    }

    private void update_MemoryElements_With_Section_Info(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/runnables");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels");
        List memoryElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element memoryElement : memoryElements) {
            String memoryElementName = memoryElement.getAttributeValue("name");
            String memoryElementID = memoryElement.getAttributeValue("id", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xmi"));
            List<Object> sections = new ArrayList();
            if (memoryElement.getName().equals("labels")) {
                sections = this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Label_Sections, memoryElementName);
                sections.addAll(this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Label_UUID_Sections, memoryElementID));
            } else if (memoryElement.getName().equals("runnables")) {
                sections = this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Runnable_Sections, memoryElementName);
                sections.addAll(this.getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum.Runnable_UUID_Sections, memoryElementID));
            }
            if (sections.isEmpty()) continue;
            String sectionName = (String)sections.get(0);
            if (this.isSectionDefinedInFile(sectionName, this.targetFile)) {
                memoryElement.setAttribute(new Attribute("section", String.valueOf(this.encodeSectionName(sectionName)) + "?type=Section"));
            } else {
                Element sectionRef = new Element("section");
                sectionRef.setAttribute("href", "amlt:/#" + this.encodeSectionName(sectionName) + "?type=Section");
                memoryElement.addContent((Content)sectionRef);
            }
            if (sections.size() <= 1) continue;
            LOGGER.warn("MemoryElement : {} is associated to multiple sections: {}. \nAs per AMALTHEA 0.7.1 it is allowed to be part of one Section only.", (Object)memoryElementName, (Object)sections.toArray());
        }
    }

    private List<String> getAssociatedSection_FromCache(SectionRunnableLabelCacheEnum type, String memoryElementName_or_UUID) {
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Set<File> fileSet = this.fileDocumentMapping.keySet();
        for (File file : fileSet) {
            Map<String, Object> map = cacheMap.get(file);
            Object object = map.get(type.name());
            if (!(object instanceof Map) || !((Map)object).containsKey(memoryElementName_or_UUID)) continue;
            return (List)((Map)object).get(memoryElementName_or_UUID);
        }
        return new ArrayList<String>();
    }

    private boolean isSectionDefinedInFile(String sectionName, File inputFile) {
        Object object;
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Map<String, Object> map = cacheMap.get(inputFile);
        return map != null && (object = map.get(SectionRunnableLabelCacheEnum.Section_Names.name())) instanceof List && ((List)object).contains(sectionName);
    }

    private SectionRunnableLabelCacheBuilder getSectionRunnableLabelCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof SectionRunnableLabelCacheBuilder)) continue;
                return (SectionRunnableLabelCacheBuilder)c;
            }
        }
        return null;
    }

    private void update_DataSize(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./swModel/typeDefinitions/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/tasks/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/isrs/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/processPrototypes/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/modeLabels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/labels/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/runnables/size");
        xpathBuffer.append("|");
        xpathBuffer.append("./swModel/customEntities/size");
        List dataSizes = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._071, (String)"am")});
        for (Element dataSizeElement : dataSizes) {
            Attribute numberBits = dataSizeElement.getAttribute("numberBits");
            if (numberBits == null) continue;
            numberBits.setName("value");
            Attribute unit = new Attribute("unit", "bit");
            dataSizeElement.setAttribute(unit);
        }
    }

    private String encodeSectionName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return "no-name";
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            result = name;
        }
        return result;
    }
}

