/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters071.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters071.utils.SectionRunnableLabelCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.0"})
public class SectionRunnableLabelCacheBuilder
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SectionRunnableLabelCacheBuilder.class);
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        LOGGER.info("Build up SectionRunnableLabelCache for 0.7.0");
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            File targetFile = entry.getKey();
            Document document1 = entry.getValue();
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            Map<String, Object> fileCache = this.map.get(targetFile);
            if (fileCache == null) {
                fileCache = new HashMap<String, Object>();
                this.map.put(targetFile, fileCache);
            }
            HashMap<String, List<String>> label_Sections_Map = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.Label_Sections.name(), label_Sections_Map);
            HashMap<String, List<String>> runnable_Sections_Map = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.Runnable_Sections.name(), runnable_Sections_Map);
            ArrayList<String> section_Names = new ArrayList<String>();
            fileCache.put(SectionRunnableLabelCacheEnum.Section_Names.name(), section_Names);
            HashMap<String, List<String>> labelUUID_Sections = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.Label_UUID_Sections.name(), labelUUID_Sections);
            HashMap<String, List<String>> runnableUUID_Sections = new HashMap<String, List<String>>();
            fileCache.put(SectionRunnableLabelCacheEnum.Runnable_UUID_Sections.name(), runnableUUID_Sections);
            List sectionElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/sections", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._070, (String)"am")});
            for (Element sectionElement : sectionElements) {
                Attribute runEntitiesAttribute;
                String sectionName = sectionElement.getAttributeValue("name");
                section_Names.add(sectionName);
                Attribute labelsAttribute = sectionElement.getAttribute("labels");
                if (labelsAttribute != null) {
                    this.extract_MemoryElement_Section_Info(label_Sections_Map, sectionName, labelsAttribute, labelUUID_Sections);
                }
                if ((runEntitiesAttribute = sectionElement.getAttribute("runEntities")) != null) {
                    this.extract_MemoryElement_Section_Info(runnable_Sections_Map, sectionName, runEntitiesAttribute, runnableUUID_Sections);
                }
                List labelElements = sectionElement.getChildren("labels");
                for (Element element : labelElements) {
                    this.extract_MemoryElement_Section_Info(label_Sections_Map, sectionName, element, labelUUID_Sections);
                }
                List runnableElements = sectionElement.getChildren("runEntities");
                for (Element element : runnableElements) {
                    this.extract_MemoryElement_Section_Info(runnable_Sections_Map, sectionName, element, runnableUUID_Sections);
                }
            }
        }
    }

    private void extract_MemoryElement_Section_Info(Map<String, List<String>> memoryElement_Sections_Map, String sectionName, Attribute memoryElementAttribute, Map<String, List<String>> memMElementUUID_Sections) {
        String memoryElementAttributeValue = memoryElementAttribute.getValue();
        StringTokenizer stk = new StringTokenizer(memoryElementAttributeValue);
        while (stk.hasMoreTokens()) {
            String memoryElementReferenceString = stk.nextToken();
            int lastIndexOf = memoryElementReferenceString.lastIndexOf(63);
            if (lastIndexOf != -1) {
                String memoryElementName = memoryElementReferenceString.substring(0, lastIndexOf);
                this.addEntry(memoryElement_Sections_Map, memoryElementName, sectionName);
                continue;
            }
            List<String> list = memMElementUUID_Sections.get(memoryElementReferenceString);
            if (list == null) {
                list = new ArrayList<String>();
                memMElementUUID_Sections.put(memoryElementReferenceString, list);
            }
            list.add(sectionName);
        }
    }

    private void extract_MemoryElement_Section_Info(Map<String, List<String>> memoryElement_Sections_Map, String sectionName, Element memoryElement, Map<String, List<String>> memElementUUID_Sections) {
        String memoryElementAttributeValue = memoryElement.getAttributeValue("href");
        if (memoryElementAttributeValue != null) {
            int indexOfHash = memoryElementAttributeValue.lastIndexOf(35);
            int indexOfQuestionmark = memoryElementAttributeValue.lastIndexOf(63);
            if (indexOfHash != -1 && indexOfQuestionmark != -1) {
                String memroyElementName = memoryElementAttributeValue.substring(indexOfHash + 1, indexOfQuestionmark);
                this.addEntry(memoryElement_Sections_Map, memroyElementName, sectionName);
            } else if (indexOfHash != -1) {
                String memoryElementID = memoryElementAttributeValue.substring(indexOfHash + 1);
                List<String> list = memElementUUID_Sections.get(memoryElementID);
                if (list == null) {
                    list = new ArrayList<String>();
                    memElementUUID_Sections.put(memoryElementID, list);
                }
                list.add(sectionName);
            }
        }
    }

    private void addEntry(Map<String, List<String>> memoryElement_Sections_Map, String memoryElementName, String sectionName) {
        if (!memoryElement_Sections_Map.containsKey(memoryElementName)) {
            memoryElement_Sections_Map.put(memoryElementName, new ArrayList());
        }
        memoryElement_Sections_Map.get(memoryElementName).add(sectionName);
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

