/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters072.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.7.1", "output_model_version=0.7.2", "service.ranking:Integer=90"}, service={IConverter.class})
public class OSConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.7.1 to 0.7.2 : Executing OS converter for model file : {}", (Object)targetFile.getName());
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_AffinityConstraints(rootElement);
        this.update_OsExecutionInstructions(rootElement);
        this.update_OsBuffering(rootElement);
    }

    private void update_OsBuffering(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/osBuffering");
        List osBufferingElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        if (!osBufferingElements.isEmpty()) {
            for (Element osBufferingElement : osBufferingElements) {
                Element osDataConsistencyElement;
                Parent osModelElement;
                String runnableLevel = osBufferingElement.getAttributeValue("runnableLevel");
                String processLevel = osBufferingElement.getAttributeValue("processLevel");
                String scheduleSectionLevel = osBufferingElement.getAttributeValue("scheduleSectionLevel");
                String bufferingAlgorithm = osBufferingElement.getAttributeValue("bufferingAlgorithm");
                if (Boolean.valueOf(runnableLevel).booleanValue() || Boolean.valueOf(processLevel).booleanValue() || Boolean.valueOf(scheduleSectionLevel).booleanValue()) {
                    osModelElement = osBufferingElement.getParent();
                    osModelElement.removeContent((Content)osBufferingElement);
                    osDataConsistencyElement = new Element("osDataConsistency");
                    osDataConsistencyElement.setAttribute("mode", "automaticProtection");
                    Element dataStabilityElement = new Element("dataStability");
                    osDataConsistencyElement.addContent((Content)dataStabilityElement);
                    dataStabilityElement.setAttribute("enabled", "true");
                    dataStabilityElement.setAttribute("algorithm", bufferingAlgorithm != null ? bufferingAlgorithm : "");
                    dataStabilityElement.setAttribute("accessMultiplicity", "multipleAccesses");
                    if (Boolean.valueOf(processLevel).booleanValue()) {
                        dataStabilityElement.setAttribute("level", "process");
                    } else if (Boolean.valueOf(runnableLevel).booleanValue()) {
                        dataStabilityElement.setAttribute("level", "runnable");
                    } else if (Boolean.valueOf(scheduleSectionLevel).booleanValue()) {
                        dataStabilityElement.setAttribute("level", "scheduleSection");
                    }
                    osModelElement.addContent((Content)osDataConsistencyElement);
                    continue;
                }
                osModelElement = osBufferingElement.getParent();
                osModelElement.removeContent((Content)osBufferingElement);
                osDataConsistencyElement = new Element("osDataConsistency");
                osDataConsistencyElement.setAttribute("mode", "noProtection");
                osModelElement.addContent((Content)osDataConsistencyElement);
            }
        } else {
            Element osModelElement = rootElement.getChild("osModel");
            if (osModelElement != null) {
                Element osDataConsistencyElement = new Element("osDataConsistency");
                osModelElement.addContent((Content)osDataConsistencyElement);
            }
        }
    }

    private void update_OsExecutionInstructions(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/operatingSystems/taskSchedulers/schedulingUnit/instructions");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/operatingSystems/interruptControllers/schedulingUnit/instructions");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSendMessage");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiTerminateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSchedule");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiRequestResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiReleaseResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSetEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiWaitEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiClearEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiActivateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiEnforcedMigration");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/postExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/postExecutionOverhead");
        List instructionElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element instructionElement : instructionElements) {
            String value;
            Attribute attribute = instructionElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            if (attribute == null || (value = attribute.getValue()) == null) continue;
            if (value.equals("am:OsExecutionInstructionsConstant")) {
                attribute.setValue("am:InstructionsConstant");
                continue;
            }
            if (!value.equals("am:OsExecutionInstructionsDeviation")) continue;
            attribute.setValue("am:InstructionsDeviation");
        }
    }

    private void update_AffinityConstraints(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/semaphores");
        List semaphoreElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element semaphoreElement : semaphoreElements) {
            Attribute attribute = semaphoreElement.getAttribute("initalValue");
            if (attribute == null) continue;
            attribute.setName("initialValue");
        }
    }
}

