/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheEnum;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class ConstraintsConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstraintsConverter.class);
    private ConstraintElementsCacheBuilder cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.0 to 0.8.1 : Executing Constraints converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getConstraintElementsCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("ConstraintElementsCacheBuilder is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateEventChainElementDefinitions_and_references(rootElement);
    }

    private void updateEventChainElementDefinitions_and_references(Element rootElement) {
        List rootEventChainElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/eventChains", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        List<String> allRootEventChainElements = this.getAllRootEventChainElements();
        if (rootEventChainElements.size() > 0) {
            for (Element rootEventChainElement : rootEventChainElements) {
                List subEventChainElements = HelperUtil.getXpathResult((Element)rootEventChainElement, (String)".//*[@xsi:type=\"am:SubEventChain\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
                for (Element subEventChainElement : subEventChainElements) {
                    Attribute typeAttribute = subEventChainElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                    if (typeAttribute == null) continue;
                    typeAttribute.setValue("am:EventChainContainer");
                }
                this.updateEventChainReferences(allRootEventChainElements, rootEventChainElement);
            }
        }
        this.updateEventChainReferences_in_TimingConstraints(allRootEventChainElements, rootElement);
    }

    private void updateEventChainReferences_in_TimingConstraints(List<String> allRootEventChainElements, Element rootElement) {
        List eventChainReferenceEleemnts = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/timingConstraints[@xsi:type=\"am:EventChainLatencyConstraint\" or @xsi:type=\"am:EventChainSynchronizationConstraint\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element timingConstraint : eventChainReferenceEleemnts) {
            List eventChains;
            String refEventChainName;
            ArrayList<String> invalidEventChainRefs = new ArrayList<String>();
            Attribute eventChainsAttribute = timingConstraint.getAttribute("scope");
            if (eventChainsAttribute != null) {
                boolean isRefEventChainStringsUpdated = false;
                String refEventChainStrings = eventChainsAttribute.getValue();
                StringTokenizer stringTokenizer = new StringTokenizer(refEventChainStrings);
                while (stringTokenizer.hasMoreTokens()) {
                    String refEventChainString = stringTokenizer.nextToken();
                    refEventChainName = refEventChainString.substring(0, refEventChainString.lastIndexOf(63));
                    if (allRootEventChainElements.contains(refEventChainName)) continue;
                    isRefEventChainStringsUpdated = true;
                    refEventChainStrings = refEventChainStrings.replace(refEventChainString, "");
                    invalidEventChainRefs.add(refEventChainString);
                    if (refEventChainStrings.trim().length() == 0) {
                        timingConstraint.removeAttribute(eventChainsAttribute);
                    }
                    this.logEventChainMessage_TimingConstraint(timingConstraint, refEventChainName);
                }
                if (isRefEventChainStringsUpdated) {
                    eventChainsAttribute.setValue(refEventChainStrings.trim());
                }
            }
            if ((eventChains = timingConstraint.getChildren("scope")) != null) {
                for (Element eventChainElement : eventChains) {
                    String hrefValue = eventChainElement.getAttributeValue("href");
                    if (hrefValue == null || !hrefValue.contains("amlt:/#") || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf(35) + 1, hrefValue.indexOf(63)))) continue;
                    timingConstraint.removeContent((Content)eventChainElement);
                    invalidEventChainRefs.add(hrefValue);
                    this.logEventChainMessage_TimingConstraint(timingConstraint, refEventChainName);
                }
            }
            if (invalidEventChainRefs.size() <= 0) continue;
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("key", "scope");
            Element valueElement = new Element("value");
            valueElement.setAttribute("type", "am:ListObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            for (String invalidEventChainRef : invalidEventChainRefs) {
                Element valuesElement = new Element("values");
                valuesElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                valuesElement.setAttribute("value", invalidEventChainRef);
                valueElement.addContent((Content)valuesElement);
            }
            customPropertyElement.addContent((Content)valueElement);
            timingConstraint.addContent((Content)customPropertyElement);
        }
    }

    private void updateEventChainReferences(List<String> allRootEventChainElements, Element rootEventChainElement) {
        List eventChainReferenceEleemnts = HelperUtil.getXpathResult((Element)rootEventChainElement, (String)".//*[@xsi:type=\"am:EventChainReference\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element eventChainReferenceElement : eventChainReferenceEleemnts) {
            String refEventChainName;
            String hrefValue;
            Element eventChainElement;
            String refEventChainName2;
            String refEventChainString;
            Attribute eventChainReferenceAttribute = eventChainReferenceElement.getAttribute("eventChain");
            if (eventChainReferenceAttribute != null && (refEventChainString = eventChainReferenceAttribute.getValue()) != null && refEventChainString.contains("?") && !allRootEventChainElements.contains(refEventChainName2 = refEventChainString.substring(0, refEventChainString.lastIndexOf(63)))) {
                eventChainReferenceElement.removeAttribute(eventChainReferenceAttribute);
                this.logEventChainMessage_and_Create_CustomProperty(rootEventChainElement, eventChainReferenceElement, refEventChainString, refEventChainName2);
            }
            if ((eventChainElement = eventChainReferenceElement.getChild("eventChain")) == null || (hrefValue = eventChainElement.getAttributeValue("href")) == null || !hrefValue.contains("amlt:/#") || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf(35) + 1, hrefValue.indexOf(63)))) continue;
            eventChainReferenceElement.removeContent((Content)eventChainElement);
            this.logEventChainMessage_and_Create_CustomProperty(rootEventChainElement, eventChainReferenceElement, hrefValue, refEventChainName);
        }
    }

    private void logEventChainMessage_TimingConstraint(Element timingConstraintElement, String refEventChainName) {
        LOGGER.warn("Sub EventChain : {} is referred inside TimingConstraint as \"Scope\": {}. As per 0.8.1, it is not valid to refer sub EventChain elements directly.\n\rEventChain {}'s association is removed from TimingConstraint object, and corresponding information is stored as a CustomProperty", new Object[]{HelperUtil.decodeName((String)refEventChainName), timingConstraintElement.getAttributeValue("name"), refEventChainName});
    }

    private void logEventChainMessage_and_Create_CustomProperty(Element rootEventChainElement, Element eventChainReferenceElement, String refEventChainString, String refEventChainName) {
        LOGGER.warn("Sub EventChain : {} is referred inside EventChainReference of EventChain : {}. As per 0.8.1, it is not valid to refer sub EventChain elements inside EventChainReference.\n\r eventChain association is removed from EventChainReference object, and corresponding information is stored as a CustomProperty", (Object)HelperUtil.decodeName((String)refEventChainName), (Object)rootEventChainElement.getAttributeValue("name"));
        Element customPropertyElement = new Element("customProperties");
        customPropertyElement.setAttribute("key", "eventChain");
        Element valueElement = new Element("value");
        valueElement.setAttribute("type", "am:StringObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
        valueElement.setAttribute("value", refEventChainString);
        customPropertyElement.addContent((Content)valueElement);
        eventChainReferenceElement.addContent((Content)customPropertyElement);
    }

    private List<String> getAllRootEventChainElements() {
        ArrayList<String> rootEventChainNames = new ArrayList<String>();
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        Collection<Map<String, Object>> values = cacheMap.values();
        for (Map<String, Object> map : values) {
            Object value = map.get(ConstraintElementsCacheEnum.ROOT_EVENTCHAIN_NAMES.name());
            if (!(value instanceof List)) continue;
            rootEventChainNames.addAll((Collection)value);
        }
        return rootEventChainNames;
    }

    private ConstraintElementsCacheBuilder getConstraintElementsCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof ConstraintElementsCacheBuilder)) continue;
                return (ConstraintElementsCacheBuilder)c;
            }
        }
        return null;
    }
}

