/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters083.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters083.utils.PeriodicStimulusCacheBuilder;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.2", "output_model_version=0.8.3"}, service={IConverter.class})
public class StimuliConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StimuliConverter.class);
    private PeriodicStimulusCacheBuilder cache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> fileDocumentMapping, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.2 to 0.8.3 : Executing Stimulus model converter for model file : {}", (Object)targetFile.getName());
        this.cache = this.getPeriodicStimulusCacheBuilder(caches);
        if (this.cache == null) {
            throw new IllegalStateException("PeriodicStimulusCacheBuilder is not built and Object of it is not available in Converters");
        }
        Document root = fileDocumentMapping.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.migrateVariableRateStimulus(rootElement);
        this.migrateSyntheticStimulus(rootElement);
        this.migrateSporadicStimulus(rootElement);
        this.migrateArrivalCurveStimulus(rootElement);
        this.migrateSingleStimulus(rootElement);
        this.migrateRemainingStimulusTypes(rootElement);
        this.migratePeriodicStimulus(rootElement);
        this.migrateStimulusReferences(rootElement);
    }

    private PeriodicStimulusCacheBuilder getPeriodicStimulusCacheBuilder(List<ICache> caches) {
        if (caches != null) {
            for (ICache c : caches) {
                if (!(c instanceof PeriodicStimulusCacheBuilder)) continue;
                return (PeriodicStimulusCacheBuilder)c;
            }
        }
        return null;
    }

    private void migrateStimulusReferences(Element rootElement) {
        StringBuilder xpathBufferForReferences = new StringBuilder();
        xpathBufferForReferences.append("./swModel/isrs");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./swModel/tasks");
        xpathBufferForReferences.append("|");
        xpathBufferForReferences.append("./eventModel/events");
        List stimulusReferenceContainers = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForReferences.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusReferenceContainer : stimulusReferenceContainers) {
            this.migrate_references_PeriodicStimulus(stimulusReferenceContainer);
            this.migrate_references_SporadicStimulus(stimulusReferenceContainer);
            this.migrate_references_SyntheticStimulus(stimulusReferenceContainer);
        }
    }

    private void migratePeriodicStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:PeriodicStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusElement : stimulusElements) {
            Element clockElement = stimulusElement.getChild("clock");
            Attribute clockAttribute = stimulusElement.getAttribute("clock");
            if (clockElement == null && clockAttribute == null) {
                Element stimulusDeviationElement = stimulusElement.getChild("stimulusDeviation");
                if (stimulusDeviationElement == null) continue;
                stimulusDeviationElement.setName("jitter");
                continue;
            }
            Attribute typeAttribute = stimulusElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:VariableRateStimulus");
            Element recurrenceElement = stimulusElement.getChild("recurrence");
            Element offsetElement = stimulusElement.getChild("offset");
            Element scenarioElement = new Element("scenario");
            if (recurrenceElement != null) {
                recurrenceElement.detach();
                scenarioElement.addContent((Content)recurrenceElement);
            }
            if (clockElement != null) {
                clockElement.detach();
                scenarioElement.addContent((Content)clockElement);
            } else if (clockAttribute != null) {
                clockAttribute.detach();
                scenarioElement.setAttribute(clockAttribute);
            }
            stimulusElement.addContent((Content)scenarioElement);
            if (offsetElement != null) {
                Element customPropertiesElement = new Element("customProperties");
                customPropertiesElement.setAttribute("key", "offset");
                offsetElement.detach();
                offsetElement.setName("value");
                offsetElement.setAttribute("type", "am:TimeObject", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                customPropertiesElement.addContent((Content)offsetElement);
                scenarioElement.addContent((Content)customPropertiesElement);
            }
            stimulusElement.removeChild("offset");
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private boolean canPeriodicStimulusTypeBeChangedForHref(String href) {
        int start = href.indexOf(35);
        int end = href.lastIndexOf(63);
        if (start != -1 && end != -1) {
            String elementName = href.substring(start + 1, end);
            return this.isPeriodicStimulusPresentInCache(elementName);
        }
        return false;
    }

    private boolean isPeriodicStimulusPresentInCache(String elementName) {
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        if (cacheMap != null) {
            Set<File> keySet = cacheMap.keySet();
            for (File file : keySet) {
                List periodicStimulus_with_clock;
                Object object;
                Map<String, Object> map = cacheMap.get(file);
                if (map == null || (object = map.get("PeriodicStimulus_Containing_Clock")) == null || !(periodicStimulus_with_clock = (List)object).contains(elementName)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkAndUpdatePeriodicStimulusReference(String reference) {
        String elementName;
        boolean result;
        int index = reference.lastIndexOf(63);
        if (index != -1 && (result = this.isPeriodicStimulusPresentInCache(elementName = reference.substring(0, index)))) {
            elementName = reference.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
            return elementName;
        }
        return reference;
    }

    private void migrateRemainingStimulusTypes(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:CustomStimulus\" or @xsi:type=\"am:InterProcessStimulus\" or @xsi:type=\"am:EventStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private void migrateSingleStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SingleStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
            Element activationElement = stimulusElement.getChild("activation");
            if (activationElement == null) continue;
            activationElement.setName("occurrence");
        }
    }

    private void migrateArrivalCurveStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:ArrivalCurveStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
            List entriesElements = stimulusElement.getChildren("entries");
            for (Element entriesElement : entriesElements) {
                Attribute attribute = entriesElement.getAttribute("numberOfEvents");
                if (attribute == null) continue;
                attribute.setName("numberOfOccurrences");
            }
        }
    }

    private void migrateSporadicStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SporadicStimulus\"]");
        List sporadicStimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element sporadicStimulusElement : sporadicStimulusElements) {
            Attribute typeAttribute = sporadicStimulusElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:RelativePeriodicStimulus");
            sporadicStimulusElement.removeAttribute("description");
            Element stimulusDeviationElement = sporadicStimulusElement.getChild("stimulusDeviation");
            if (stimulusDeviationElement == null) continue;
            stimulusDeviationElement.setName("nextOccurrence");
        }
    }

    private void migrateVariableRateStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:VariableRateStimulus\"]");
        List stimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element stimulusElement : stimulusElements) {
            stimulusElement.removeChild("stimulusDeviation");
        }
    }

    private void migrateSyntheticStimulus(Element rootElement) {
        StringBuilder xpathBufferForDefinition = new StringBuilder();
        xpathBufferForDefinition.append("./stimuliModel/stimuli[@xsi:type=\"am:SyntheticStimulus\"]");
        List syntheticStimulusElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBufferForDefinition.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
        for (Element syntheticStimulusElement : syntheticStimulusElements) {
            Element triggerTimesElement;
            Attribute typeAttribute = syntheticStimulusElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
            typeAttribute.setValue("am:PeriodicSyntheticStimulus");
            syntheticStimulusElement.removeChild("stimulusDeviation");
            Element periodElement = syntheticStimulusElement.getChild("period");
            if (periodElement != null) {
                periodElement.setName("recurrence");
            }
            if ((triggerTimesElement = syntheticStimulusElement.getChild("triggerTimes")) == null) continue;
            List timeStampsElements = HelperUtil.getXpathResult((Element)triggerTimesElement, (String)".//timestamps", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"), AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._083, (String)"am")});
            for (Element timeStampsElement : timeStampsElements) {
                timeStampsElement.setName("occurrenceTimes");
                timeStampsElement.detach();
                syntheticStimulusElement.addContent((Content)timeStampsElement);
            }
            syntheticStimulusElement.removeContent((Content)triggerTimesElement);
        }
    }

    private void migrate_references_SporadicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = stimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SporadicStimulus")) {
                    typeAttribute.setValue("am:RelativePeriodicStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replaceAll("\\?type\\=SporadicStimulus", "?type=RelativePeriodicStimulus");
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = stimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SporadicStimulus")) {
                    typeAttribute.setValue("am:RelativePeriodicStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace("?type=SporadicStimulus", "?type=RelativePeriodicStimulus");
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrate_references_SyntheticStimulus(Element syntheticStimulusReferenceContainer) {
        String containerTagName = syntheticStimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = syntheticStimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                Attribute hrefAttribute;
                if (stimuliElement == null) continue;
                Attribute typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SyntheticStimulus")) {
                    typeAttribute.setValue("am:PeriodicSyntheticStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) == null) continue;
                String value = hrefAttribute.getValue();
                value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                hrefAttribute.setValue(value);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replaceAll("\\?type\\=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = syntheticStimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = syntheticStimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:SyntheticStimulus")) {
                    typeAttribute.setValue("am:PeriodicSyntheticStimulus");
                }
                if ((hrefAttribute = stimuliElement.getAttribute("href")) != null) {
                    String value = hrefAttribute.getValue();
                    value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                    hrefAttribute.setValue(value);
                }
            } else if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                value = value.replace("?type=SyntheticStimulus", "?type=PeriodicSyntheticStimulus");
                stimuliAttribute.setValue(value);
            }
        }
    }

    private void migrate_references_PeriodicStimulus(Element stimulusReferenceContainer) {
        String containerTagName = stimulusReferenceContainer.getName();
        if (containerTagName.equals("isrs") || containerTagName.equals("tasks")) {
            List stimuliElements = stimulusReferenceContainer.getChildren("stimuli");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("stimuli");
            for (Element stimuliElement : stimuliElements) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute;
                if (stimuliElement == null || (typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) == null || !typeAttribute.getValue().equals("am:PeriodicStimulus") || (hrefAttribute = stimuliElement.getAttribute("href")) == null || !this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) continue;
                typeAttribute.setValue("am:VariableRateStimulus");
                hrefValue = hrefValue.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
                hrefAttribute.setValue(hrefValue);
            }
            if (stimuliAttribute != null) {
                String value = stimuliAttribute.getValue();
                String[] split = value.split("\\s+");
                StringBuilder updatedRefsBuffer = new StringBuilder();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String reference = stringArray[n2];
                    if (reference.contains("?type=PeriodicStimulus")) {
                        updatedRefsBuffer.append(String.valueOf(this.checkAndUpdatePeriodicStimulusReference(reference)) + " ");
                    } else {
                        updatedRefsBuffer.append(String.valueOf(reference) + " ");
                    }
                    ++n2;
                }
                value = updatedRefsBuffer.toString().trim();
                stimuliAttribute.setValue(value);
            }
        } else if (containerTagName.equals("events")) {
            Element stimuliElement = stimulusReferenceContainer.getChild("entity");
            Attribute stimuliAttribute = stimulusReferenceContainer.getAttribute("entity");
            if (stimuliElement != null) {
                String hrefValue;
                Attribute hrefAttribute;
                Attribute typeAttribute = stimuliElement.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"));
                if (typeAttribute != null && typeAttribute.getValue().equals("am:PeriodicStimulus") && (hrefAttribute = stimuliElement.getAttribute("href")) != null && this.canPeriodicStimulusTypeBeChangedForHref(hrefValue = hrefAttribute.getValue())) {
                    typeAttribute.setValue("am:VariableRateStimulus");
                    hrefValue = hrefValue.replace("?type=PeriodicStimulus", "?type=VariableRateStimulus");
                    hrefAttribute.setValue(hrefValue);
                }
            } else if (stimuliAttribute != null) {
                String reference = stimuliAttribute.getValue();
                if (reference.contains("?type=PeriodicStimulus")) {
                    reference = this.checkAndUpdatePeriodicStimulusReference(reference);
                }
                stimuliAttribute.setValue(reference);
            }
        }
    }
}

