/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Document;

public class MigrationSettings
implements AutoCloseable {
    private List<MigrationInputFile> migModelFiles = new ArrayList<MigrationInputFile>();
    private String inputModelVersion;
    private String migrationModelVersion = ModelVersion.getLatestVersion();
    private String outputDirectoryLocation;
    private File project;
    private boolean createBackupFile = true;

    public File getProject() {
        return this.project;
    }

    public void setProject(File project) {
        this.project = project;
        if (this.project != null) {
            this.setOutputDirectoryLocation(String.valueOf(this.project.getAbsolutePath()) + File.separator + "_migration");
        }
    }

    public String getOutputDirectoryLocation() {
        return this.outputDirectoryLocation;
    }

    public void setOutputDirectoryLocation(String outputDirectoryLocation) {
        this.outputDirectoryLocation = outputDirectoryLocation;
    }

    public List<MigrationInputFile> getMigModelFiles() {
        return this.migModelFiles;
    }

    public void setMigModelFiles(List<MigrationInputFile> migModelFiles) {
        this.migModelFiles = migModelFiles;
    }

    public String getInputModelVersion() {
        return this.inputModelVersion;
    }

    public void setInputModelVersion(String inputModelVersion) {
        this.inputModelVersion = inputModelVersion;
    }

    public String getMigrationModelVersion() {
        return this.migrationModelVersion;
    }

    public void setMigrationModelVersion(String migrationModelVersion) {
        this.migrationModelVersion = migrationModelVersion;
    }

    public boolean isCreateBackupFile() {
        return this.createBackupFile;
    }

    public void setCreateBackupFile(boolean createBackupFile) {
        this.createBackupFile = createBackupFile;
    }

    public Map<File, Document> getMigModelFilesMap() {
        HashMap<File, Document> migModelsMap = new HashMap<File, Document>();
        for (MigrationInputFile migModelFile : this.migModelFiles) {
            Document document = migModelFile.getDocument();
            if (document == null) continue;
            migModelsMap.put(migModelFile.getFile(), document);
        }
        return migModelsMap;
    }

    @Override
    public synchronized void close() {
        this.migModelFiles.forEach(MigrationInputFile::dispose);
    }
}

