/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.headless.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"osgi.command.scope:String=app4mc", "osgi.command.function:String=convert"}, service={ModelMigrationCommand.class})
public class ModelMigrationCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelMigrationCommand.class);
    @Reference
    MigrationProcessor migrationProcessor;

    @Descriptor(value="Start an APP4MC AMALTHEA model migration")
    public void convert(@Descriptor(value="The model version to which the model should be migrated to") @Parameter(absentValue="latest", names={"-v", "--version"}) String modelVersion, @Descriptor(value="true/false whether the migration should be performed recursive on the provided folder or not (default=false)") @Parameter(absentValue="false", names={"-r", "--recursive"}) boolean recursive, @Descriptor(value="true/false whether the backup files per model file should be created or not (default=false)") @Parameter(absentValue="false", names={"-nb", "--nobackup"}) boolean noBackup, @Descriptor(value="The filename of the model file or the folder that contains model files to migrate") String filename) {
        block16: {
            Path modelFilePath = Paths.get(filename, new String[0]).toAbsolutePath();
            if (!Files.exists(modelFilePath, new LinkOption[0])) {
                LOGGER.error("Model file or folder \"{}\" does not exist!", (Object)filename);
                return;
            }
            String outputModelVersion = ModelVersion.getLatestVersion();
            if (!"latest".equals(modelVersion)) {
                ModelVersion version = ModelVersion.getModelVersion((String)modelVersion);
                if (version != null) {
                    outputModelVersion = modelVersion;
                } else {
                    LOGGER.error("Migration model version {} is invalid", (Object)modelVersion);
                    return;
                }
            }
            if (Files.isDirectory(modelFilePath, new LinkOption[0])) {
                this.convertDirectory(modelFilePath, outputModelVersion, recursive, noBackup);
            } else {
                if (modelFilePath.toString().toLowerCase().endsWith(".amxmi")) {
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try (MigrationSettings migrationSettings = new MigrationSettings();){
                        migrationSettings.setProject(modelFilePath.getParent().toFile());
                        migrationSettings.setMigrationModelVersion(outputModelVersion);
                        this.convert(Arrays.asList(modelFilePath.toFile()), migrationSettings, noBackup);
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                LOGGER.error("Given parameter \"{}\" is neither a directory nor a model file!", (Object)filename);
            }
        }
    }

    private void convertDirectory(Path modelFilePath, String outputModelVersion, boolean recursive, boolean noBackup) {
        Stream<Path> directoryStream;
        Object var6_10;
        block33: {
            try {
                Throwable throwable = null;
                var6_10 = null;
                try {
                    directoryStream = Files.walk(modelFilePath, 1, new FileVisitOption[0]);
                    try {
                        List<File> modelFiles = directoryStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(file -> file.toString().toLowerCase().endsWith(".amxmi")).map(Path::toFile).collect(Collectors.toList());
                        if (modelFiles.isEmpty()) break block33;
                        Throwable throwable2 = null;
                        Iterator iterator = null;
                        try (MigrationSettings migrationSettings = new MigrationSettings();){
                            migrationSettings.setProject(modelFilePath.toFile());
                            migrationSettings.setMigrationModelVersion(outputModelVersion);
                            this.convert(modelFiles, migrationSettings, noBackup);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (directoryStream != null) {
                            directoryStream.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load model files", (Throwable)e);
                return;
            }
        }
        if (recursive) {
            try {
                Throwable e = null;
                var6_10 = null;
                try {
                    directoryStream = Files.walk(modelFilePath, 1, new FileVisitOption[0]);
                    try {
                        List modelDirectories = directoryStream.filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(file -> {
                            try {
                                return !Files.isSameFile(file, modelFilePath);
                            }
                            catch (IOException e) {
                                return false;
                            }
                        }).collect(Collectors.toList());
                        for (Path path2 : modelDirectories) {
                            this.convertDirectory(path2, outputModelVersion, recursive, noBackup);
                        }
                    }
                    finally {
                        if (directoryStream != null) {
                            directoryStream.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load model files", (Throwable)e);
                return;
            }
        }
    }

    private void convert(List<File> inputFiles, MigrationSettings migrationSettings, boolean noBackup) {
        try {
            List modelFiles = MigrationHelper.populateModels(inputFiles, (MigrationSettings)migrationSettings);
            migrationSettings.getMigModelFiles().addAll(modelFiles);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load model files", (Throwable)e);
            return;
        }
        try {
            boolean inputValid = MigrationHelper.isInputModelVersionValid((MigrationSettings)migrationSettings);
            if (!inputValid) {
                LOGGER.error("Model migration stopped in {} as selected model files belong to different versions", (Object)migrationSettings.getOutputDirectoryLocation());
                return;
            }
            if (migrationSettings.getInputModelVersion() != null && ModelVersion.getLatestVersion().equals(migrationSettings.getInputModelVersion())) {
                LOGGER.error("Selected models are compatible to latest AMALTHEA meta-model version {}.\nIt is not required to migrate the models in {}", (Object)ModelVersion.getLatestVersion(), (Object)migrationSettings.getOutputDirectoryLocation());
                return;
            }
            Map migStepEntries = MigrationHelper.generateMigrationSteps((String)migrationSettings.getInputModelVersion(), (String)migrationSettings.getMigrationModelVersion());
            if (migStepEntries.size() == 0) {
                LOGGER.error("Migration not supported for the selected model versions.\nInput Model version : \"{}\" Output Model Version : \"{}\"", (Object)migrationSettings.getInputModelVersion(), (Object)migrationSettings.getMigrationModelVersion());
                return;
            }
            MigrationInputFile migrationInputFile = (MigrationInputFile)migrationSettings.getMigModelFiles().get(0);
            migrationSettings.setOutputDirectoryLocation(migrationInputFile.getOriginalFile().getParent());
            boolean backupSucceeded = true;
            if (!noBackup) {
                for (MigrationInputFile input : migrationSettings.getMigModelFiles()) {
                    backupSucceeded = MigrationHelper.createBackupFile((MigrationInputFile)input);
                }
            }
            if (backupSucceeded) {
                int result = this.migrationProcessor.execute(migrationSettings, null);
                switch (result) {
                    case 20: {
                        LOGGER.error("Migration in " + migrationSettings.getOutputDirectoryLocation() + " not supported for the selected model versions. \nInput Model version : \"" + migrationSettings.getInputModelVersion() + "\" Output Model Version : \"" + migrationSettings.getMigrationModelVersion() + "\"");
                        break;
                    }
                    case 30: {
                        LOGGER.error("Error during migration in {}", (Object)migrationSettings.getOutputDirectoryLocation());
                        break;
                    }
                    default: {
                        System.out.println("Model Migration in " + migrationSettings.getOutputDirectoryLocation() + " successful !!");
                        break;
                    }
                }
            } else {
                LOGGER.error("Migration Stopped : Source files could not be backed up before migration in {}", (Object)migrationSettings.getOutputDirectoryLocation());
            }
        }
        catch (MigrationException e) {
            LOGGER.error("Error during migration in {} : {}", (Object)migrationSettings.getOutputDirectoryLocation(), (Object)e.getLocalizedMessage());
        }
    }
}

