/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.log4j.configuration;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.FileAppender;

public class MigrationSessionFileAppender
extends FileAppender {
    private String dateFormat;
    private String currentOutputDirectory;

    protected boolean checkEntryConditions() {
        String outputDirectory = System.getProperty("APP4MC_MIGRATION_OUTPUT_DIRECTORY");
        if (outputDirectory != null) {
            if (this.currentOutputDirectory == null || !this.currentOutputDirectory.equals(outputDirectory)) {
                this.closeFile();
                this.currentOutputDirectory = outputDirectory;
                this.createNewFile();
            }
            return super.checkEntryConditions();
        }
        if (this.currentOutputDirectory != null) {
            this.closeFile();
            this.currentOutputDirectory = null;
        }
        return false;
    }

    private void createNewFile() {
        String dateToStr = new SimpleDateFormat(this.dateFormat).format(new Date());
        super.setFile(new File(this.currentOutputDirectory, "ModelMigration__" + dateToStr + ".log").getAbsolutePath());
        super.activateOptions();
    }

    public void activateOptions() {
        if (this.fileName != null) {
            super.activateOptions();
        }
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

