/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.ChannelReceive;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.LabelAccessTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.RunnableTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.TicksTransformer;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;

@Singleton
public class ActivityGraphItemTransformer
extends SLGBaseTransformer {
    private static final String UNSUPPORTED_ELEMENT = "Unsupported element inside ActivityGraph : {0}";
    @Inject
    private SessionLogger logger;
    @Inject
    private RunnableTransformer runnableTransformer;
    @Inject
    private LabelAccessTransformer labelAccessTransformer;
    @Inject
    private TicksTransformer ticksTransformer;

    public SLGTranslationUnit transform(ActivityGraphItem graphItem) {
        if (graphItem == null) {
            throw new IllegalArgumentException("Unhandled parameter type: null");
        }
        if (graphItem instanceof LabelAccess) {
            return this.labelAccessTransformer.transform((LabelAccess)graphItem);
        }
        if (graphItem instanceof Ticks) {
            return this.ticksTransformer.transform((Ticks)graphItem);
        }
        if (graphItem instanceof RunnableCall) {
            return this.runnableTransformer.transform(((RunnableCall)graphItem).getRunnable());
        }
        if (graphItem instanceof ChannelReceive) {
            this.logger.error(UNSUPPORTED_ELEMENT, new Object[]{"ChannelReceive"});
            return new SLGTranslationUnit("ChannelReceive is not yet implemented");
        }
        if (graphItem instanceof ChannelSend) {
            this.logger.error(UNSUPPORTED_ELEMENT, new Object[]{"ChannelSend"});
            return new SLGTranslationUnit("ChannelSend is not yet implemented");
        }
        this.logger.error(UNSUPPORTED_ELEMENT, new Object[]{graphItem.getClass().getName()});
        return new SLGTranslationUnit(String.valueOf(graphItem.eClass().getName()) + " in not supported");
    }

    public Map<String, SLGTranslationUnit> transformAllItems(Ticks ticks) {
        return this.ticksTransformer.transformAllItems(ticks);
    }
}

