/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.config.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.ConfigurationPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public final class ConfigurationFileLoader {
    private ConfigurationFileLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static ConfigModel loadConfigurationFile(String filePath) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://config", (Object)ConfigurationPackage.eINSTANCE);
        File file = new File(filePath);
        try {
            EObject eObject;
            String path = file.getCanonicalPath();
            URI uri = file.isFile() ? URI.createFileURI((String)path) : URI.createURI((String)path);
            Resource resource = resourceSet.getResource(uri, true);
            EList contents = resource.getContents();
            if (!contents.isEmpty() && (eObject = (EObject)contents.get(0)) instanceof ConfigModel) {
                return (ConfigModel)eObject;
            }
        }
        catch (IOException | RuntimeException exception) {
            throw new IllegalStateException("Error on loading configuration file", exception);
        }
        return null;
    }
}

