/**
 * *******************************************************************************
 *  Copyright (c) 2020 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.slg.config.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.app4mc.slg.config.util.ConfigurationAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ConfigurationItemProviderAdapterFactory extends ConfigurationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "*******************************************************************************\n Copyright (c) 2020 Robert Bosch GmbH and others.\n\n This program and the accompanying materials are made\n available under the terms of the Eclipse Public License 2.0\n which is available at https://www.eclipse.org/legal/epl-2.0/\n\n SPDX-License-Identifier: EPL-2.0\n\n    Generated using Eclipse EMF\n\n*******************************************************************************";

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.ConfigModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigModelItemProvider configModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.ConfigModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigModelAdapter() {
		if (configModelItemProvider == null) {
			configModelItemProvider = new ConfigModelItemProvider(this);
		}

		return configModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.CustomImpl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomImplItemProvider customImplItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.CustomImpl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomImplAdapter() {
		if (customImplItemProvider == null) {
			customImplItemProvider = new CustomImplItemProvider(this);
		}

		return customImplItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.CustomTickImpl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomTickImplItemProvider customTickImplItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.CustomTickImpl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomTickImplAdapter() {
		if (customTickImplItemProvider == null) {
			customTickImplItemProvider = new CustomTickImplItemProvider(this);
		}

		return customTickImplItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.CustomReadImpl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomReadImplItemProvider customReadImplItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.CustomReadImpl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomReadImplAdapter() {
		if (customReadImplItemProvider == null) {
			customReadImplItemProvider = new CustomReadImplItemProvider(this);
		}

		return customReadImplItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.CustomWriteImpl} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CustomWriteImplItemProvider customWriteImplItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.CustomWriteImpl}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCustomWriteImplAdapter() {
		if (customWriteImplItemProvider == null) {
			customWriteImplItemProvider = new CustomWriteImplItemProvider(this);
		}

		return customWriteImplItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.CodeHooks} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CodeHooksItemProvider codeHooksItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.CodeHooks}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCodeHooksAdapter() {
		if (codeHooksItemProvider == null) {
			codeHooksItemProvider = new CodeHooksItemProvider(this);
		}

		return codeHooksItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.LibLocations} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LibLocationsItemProvider libLocationsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.LibLocations}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLibLocationsAdapter() {
		if (libLocationsItemProvider == null) {
			libLocationsItemProvider = new LibLocationsItemProvider(this);
		}

		return libLocationsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.app4mc.slg.config.HeaderFiles} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HeaderFilesItemProvider headerFilesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.app4mc.slg.config.HeaderFiles}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHeaderFilesAdapter() {
		if (headerFilesItemProvider == null) {
			headerFilesItemProvider = new HeaderFilesItemProvider(this);
		}

		return headerFilesItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (configModelItemProvider != null) configModelItemProvider.dispose();
		if (customImplItemProvider != null) customImplItemProvider.dispose();
		if (customTickImplItemProvider != null) customTickImplItemProvider.dispose();
		if (customReadImplItemProvider != null) customReadImplItemProvider.dispose();
		if (customWriteImplItemProvider != null) customWriteImplItemProvider.dispose();
		if (codeHooksItemProvider != null) codeHooksItemProvider.dispose();
		if (libLocationsItemProvider != null) libLocationsItemProvider.dispose();
		if (headerFilesItemProvider != null) headerFilesItemProvider.dispose();
	}

}
