/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.generators;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.PlatformArchitecture;
import org.eclipse.app4mc.slg.linux.generators.CodeSnippet;
import org.eclipse.app4mc.slg.linux.generators.LinuxRealisiticSyntheticGenerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LinuxRunnableGenerator {
    private LinuxRunnableGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String snippetSrcStart(ConfigModel configModel) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"runnables.h\"");
        _builder.newLine();
        _builder.append("#include \"codesnippets.h\"");
        _builder.newLine();
        _builder.newLine();
        PlatformArchitecture platformArchitectureType = configModel.getPlatformArchitectureType();
        _builder.newLineIfNotEmpty();
        if (platformArchitectureType != null) {
            _builder.append(" #define __");
            String _name = platformArchitectureType.getName();
            _builder.append(_name);
            _builder.append("__");
        }
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("void ticks(int numberTicks){");
        _builder.newLine();
        _builder.append("#\tif defined (__x86_64__)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for(int i = 0; i < numberTicks; i++){");
        _builder.newLine();
        IntegerRange _upTo = new IntegerRange(1, 400);
        for (Integer k : _upTo) {
            _builder.append("\t\t");
            _builder.append("__asm volatile(\"nop\");");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("#\telif defined (__x86_32__) ");
        _builder.newLine();
        _builder.append("for(int i = 0; i < numberTicks; i++){");
        _builder.newLine();
        IntegerRange _upTo_1 = new IntegerRange(1, 400);
        for (Integer k_1 : _upTo_1) {
            _builder.append("\t\t");
            _builder.append("__asm volatile(\"mov r0, r0\");");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("#\telif defined (__aarch64__) \t");
        _builder.newLine();
        _builder.append("for(int i = 0; i < numberTicks; i++){");
        _builder.newLine();
        IntegerRange _upTo_2 = new IntegerRange(1, 400);
        for (Integer k_2 : _upTo_2) {
            _builder.append("\t\t");
            _builder.append("__asm volatile(\"mov x0, x0\");");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public static String snippetSrcBody(Runnable runnable, String codeString, boolean enableExtCode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//Runnable ");
        String _name = null;
        if (runnable != null) {
            _name = runnable.getName();
        }
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("void run_");
        String _name_1 = null;
        if (runnable != null) {
            _name_1 = runnable.getName();
        }
        _builder.append(_name_1);
        _builder.append("(char* coreName){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(codeString, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public static String snippetIncStart() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"codesnippets.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ticks(int numberTicks);");
        _builder.newLine();
        return _builder.toString();
    }

    public static String syntheticLoad(Runnable runnable, boolean experimental, Properties properties, boolean enableExtCode) {
        Calculation calc = new Calculation();
        StringBuffer codeHookFunctionsBuffer = new StringBuffer();
        StringBuffer codeHookFunctionsOverwriteBuffer = new StringBuffer();
        LinuxRunnableGenerator.updateContent(runnable, calc, properties, codeHookFunctionsBuffer, codeHookFunctionsOverwriteBuffer);
        StringConcatenation _builder = new StringConcatenation();
        if (enableExtCode) {
            boolean _equals;
            int _length = codeHookFunctionsOverwriteBuffer.length();
            boolean bl = _equals = _length == 0;
            if (_equals) {
                _builder.newLine();
                _builder.append("\t");
                _builder.append((Object)codeHookFunctionsBuffer, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.newLine();
                _builder.append("\t");
                _builder.append((Object)codeHookFunctionsOverwriteBuffer, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        if (!enableExtCode || codeHookFunctionsOverwriteBuffer.length() == 0) {
            _builder.append("    ");
            _builder.append("\t\t\t");
            boolean extendedFound = false;
            _builder.newLineIfNotEmpty();
            List _sort = IterableExtensions.sort(calc.ticksSumMap.keySet());
            for (String puName : _sort) {
                boolean _not;
                boolean _equals_1 = puName.equals("default");
                boolean bl = _not = !_equals_1;
                if (!_not) continue;
                _builder.append("\t\t");
                if (extendedFound) {
                    _builder.append("else");
                }
                _builder.append(" if(strcmp(coreName,\"");
                _builder.append(puName, "\t\t");
                _builder.append("\")==0){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _syntheticLoadContentForEachPU = LinuxRunnableGenerator.syntheticLoadContentForEachPU(experimental, calc, puName);
                _builder.append(_syntheticLoadContentForEachPU, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t\t");
                String _xblockexpression = null;
                extendedFound = true;
                _xblockexpression = "";
                _builder.append(_xblockexpression, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            boolean _containsKey = calc.ticksSumMap.containsKey("default");
            if (_containsKey) {
                _builder.append("\t\t");
                _builder.newLine();
                _builder.append("\t\t");
                String value = LinuxRunnableGenerator.syntheticLoadContentForEachPU(experimental, calc, "default");
                _builder.newLineIfNotEmpty();
                if (value != null && value.length() > 0) {
                    _builder.append("\t\t");
                    if (extendedFound) {
                        _builder.append("else");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append(" ");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append(" \t");
                    _builder.append(value, "\t\t \t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append(" ");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append(" ");
                    _builder.newLine();
                }
            }
        }
        String buffer = _builder.toString();
        return buffer;
    }

    public static void updateContent(Runnable runnable, final Calculation calculation, final Properties properties, final StringBuffer codehookFct, final StringBuffer codehookFctOverwrite) {
        calculation.ticksSumMap.put("default", 0);
        ActivityGraph _activityGraph = null;
        if (runnable != null) {
            _activityGraph = runnable.getActivityGraph();
        }
        EList _eContents = null;
        if (_activityGraph != null) {
            _eContents = _activityGraph.eContents();
        }
        if (_eContents != null) {
            Consumer<EObject> _function = new Consumer<EObject>(){

                @Override
                public void accept(EObject item) {
                    if (item instanceof Ticks) {
                        Integer _get = calculation.ticksSumMap.get("default");
                        IDiscreteValueDeviation _default = null;
                        if ((Ticks)item != null) {
                            _default = ((Ticks)item).getDefault();
                        }
                        Double _average = null;
                        if (_default != null) {
                            _average = _default.getAverage();
                        }
                        int _intValue = 0;
                        if (_average != null) {
                            _intValue = _average.intValue();
                        }
                        int _plus = _get + _intValue;
                        calculation.ticksSumMap.put("default", _plus);
                        EMap _extended = null;
                        if ((Ticks)item != null) {
                            _extended = ((Ticks)item).getExtended();
                        }
                        Set _keySet = null;
                        if (_extended != null) {
                            _keySet = _extended.keySet();
                        }
                        Set puDefinitions = _keySet;
                        for (ProcessingUnitDefinition puDefinition : puDefinitions) {
                            boolean _not;
                            if (puDefinition == null) continue;
                            boolean _containsKey = calculation.ticksSumMap.containsKey(puDefinition.getName());
                            boolean bl = _not = !_containsKey;
                            if (_not) {
                                calculation.ticksSumMap.put(puDefinition.getName(), 0);
                            }
                            String _name = puDefinition.getName();
                            Integer _get_1 = calculation.ticksSumMap.get(puDefinition.getName());
                            EMap _extended_1 = null;
                            if ((Ticks)item != null) {
                                _extended_1 = ((Ticks)item).getExtended();
                            }
                            IDiscreteValueDeviation _get_2 = null;
                            if (_extended_1 != null) {
                                _get_2 = (IDiscreteValueDeviation)_extended_1.get((Object)puDefinition);
                            }
                            Double _average_1 = null;
                            if (_get_2 != null) {
                                _average_1 = _get_2.getAverage();
                            }
                            int _intValue_1 = 0;
                            if (_average_1 != null) {
                                _intValue_1 = _average_1.intValue();
                            }
                            int _plus_1 = _get_1 + _intValue_1;
                            calculation.ticksSumMap.put(_name, _plus_1);
                        }
                    } else if (item instanceof LabelAccess) {
                        String _string;
                        boolean _equals;
                        Float value = Float.valueOf(Float.parseFloat(properties.getOrDefault((Object)"labelAccessStatisticValueDefault", "1.0F").toString()));
                        LabelAccessStatistic labelStatistic = ((LabelAccess)item).getStatistic();
                        if (labelStatistic != null) {
                            NumericStatistic labelStatisticValue = labelStatistic.getValue();
                            if (labelStatisticValue instanceof SingleValueStatistic) {
                                value = Float.valueOf(((SingleValueStatistic)labelStatisticValue).getValue());
                            } else if (labelStatisticValue instanceof MinAvgMaxStatistic) {
                                value = Float.valueOf(((MinAvgMaxStatistic)labelStatisticValue).getAvg());
                            }
                        }
                        if (_equals = Objects.equal((Object)(_string = ((LabelAccess)item).getAccess().toString()), (Object)"read")) {
                            int _readsSum = calculation.readsSum;
                            int _intValue_2 = value.intValue();
                            calculation.readsSum = _readsSum + _intValue_2;
                        } else {
                            String _string_1 = ((LabelAccess)item).getAccess().toString();
                            boolean _equals_1 = Objects.equal((Object)_string_1, (Object)"write");
                            if (_equals_1) {
                                int _writesSum = calculation.writesSum;
                                int _intValue_3 = value.intValue();
                                calculation.writesSum = _writesSum + _intValue_3;
                            }
                        }
                    } else if (item instanceof CustomPropertyImpl) {
                        boolean _equals_2 = ((CustomPropertyImpl)item).getKey().equals("codehook_overwrite");
                        if (_equals_2) {
                            Value value_1 = ((CustomPropertyImpl)item).getValue();
                            if (value_1 instanceof StringObject) {
                                String _value = ((StringObject)value_1).getValue();
                                String _plus_2 = String.valueOf(_value) + ";";
                                codehookFctOverwrite.append(_plus_2);
                                codehookFctOverwrite.append(System.getProperty("line.separator"));
                                codehookFctOverwrite.append(System.getProperty("line.separator"));
                            }
                        } else {
                            Value value_2;
                            boolean _equals_3 = ((CustomPropertyImpl)item).getKey().equals("codehook");
                            if (_equals_3 && (value_2 = ((CustomPropertyImpl)item).getValue()) instanceof StringObject) {
                                String _value_1 = ((StringObject)value_2).getValue();
                                String _plus_3 = String.valueOf(_value_1) + ";";
                                codehookFct.append(_plus_3);
                                codehookFct.append(System.getProperty("line.separator"));
                                codehookFct.append(System.getProperty("line.separator"));
                            }
                        }
                    }
                }
            };
            _eContents.forEach((Consumer)_function);
        }
    }

    private static String syntheticLoadContentForEachPU(boolean experimental, Calculation calc, String puName) {
        calc.resetCalculatedTicksSum();
        calc.calculatedTicksSum = calc.ticksSumMap.get(puName);
        if (calc.readsSum != 0 && calc.readsSum < 10) {
            calc.readsSum = 10;
        }
        if (calc.writesSum != 0 && calc.writesSum < 10) {
            calc.writesSum = 10;
        }
        calc.matchingCodeSnippetIdsBuffer = "";
        LinuxRunnableGenerator.performCodeSnippetMatching(experimental, calc);
        int _calculatedTicksSum = calc.calculatedTicksSum;
        int _intValue = Double.valueOf((double)calc.writesSum * 1.0171).intValue();
        int _calculatedTicksSum_1 = calc.calculatedTicksSum = _calculatedTicksSum - _intValue;
        int _intValue_1 = Double.valueOf((double)calc.readsSum * 1.0067).intValue();
        int _calculatedTicksSum_2 = calc.calculatedTicksSum = _calculatedTicksSum_1 - _intValue_1;
        calc.calculatedTicksSum = _calculatedTicksSum_2 / 400;
        int _readsSum = calc.readsSum;
        calc.readsSum = _readsSum / 10;
        int _writesSum = calc.writesSum;
        calc.writesSum = _writesSum / 10;
        if (calc.calculatedTicksSum > 0 && calc.matchingCodeSnippetIdsBuffer.length() == 0) {
            LinuxRunnableGenerator.caseWithOnlyTicks(calc);
            return calc.matchingCodeSnippetIdsBuffer;
        }
        if (calc.calculatedTicksSum <= 0 && (calc.writesSum > 0 || calc.readsSum > 0) && calc.matchingCodeSnippetIdsBuffer.length() == 0) {
            LinuxRunnableGenerator.caseWithOutTicksButWithLabelAccesses(calc);
            return calc.matchingCodeSnippetIdsBuffer;
        }
        if (calc.calculatedTicksSum > 0 && calc.matchingCodeSnippetIdsBuffer.length() != 0) {
            LinuxRunnableGenerator.caseWithTicksAndMatchingCodeSnippets(calc);
            return calc.matchingCodeSnippetIdsBuffer;
        }
        return null;
    }

    private static void performCodeSnippetMatching(boolean experimental, Calculation calc) {
        int i = 0;
        boolean added = false;
        List<CodeSnippet> codesnippets = LinuxRealisiticSyntheticGenerator.getCodeSnippets();
        if (experimental) {
            i = 0;
            while (i < ((Object[])Conversions.unwrapArray(codesnippets, Object.class)).length) {
                int ticks_net;
                if (i == 0) {
                    added = false;
                }
                if ((ticks_net = codesnippets.get((int)i).ticks - codesnippets.get((int)i).stallsload - codesnippets.get((int)i).stallsstore) < calc.calculatedTicksSum && codesnippets.get((int)i).reads < calc.readsSum && codesnippets.get((int)i).writes < calc.writesSum) {
                    String _matchingCodeSnippetIdsBuffer = calc.matchingCodeSnippetIdsBuffer;
                    String _property = System.getProperty("line.separator");
                    String _plus = String.valueOf(codesnippets.get((int)i).name) + "();/\n" + _property;
                    calc.matchingCodeSnippetIdsBuffer = String.valueOf(_matchingCodeSnippetIdsBuffer) + _plus;
                    int _calculatedTicksSum = calc.calculatedTicksSum;
                    calc.calculatedTicksSum = _calculatedTicksSum - ticks_net;
                    int _readsSum = calc.readsSum;
                    calc.readsSum = _readsSum - codesnippets.get((int)i).reads;
                    int _writesSum = calc.writesSum;
                    calc.writesSum = _writesSum - codesnippets.get((int)i).writes;
                    added = true;
                }
                if (added && i == ((Object[])Conversions.unwrapArray(codesnippets, Object.class)).length - 1) {
                    i = -1;
                }
                ++i;
            }
        }
    }

    private static void caseWithTicksAndMatchingCodeSnippets(final Calculation calc) {
        String[] matchingCodeSnippetsIdsArray = calc.matchingCodeSnippetIdsBuffer.split("/");
        int numberOfCodeSnippets = matchingCodeSnippetsIdsArray.length;
        int _writesSum = calc.writesSum;
        calc.writesSum = _writesSum / numberOfCodeSnippets;
        int _readsSum = calc.readsSum;
        calc.readsSum = _readsSum / numberOfCodeSnippets;
        int _calculatedTicksSum = calc.calculatedTicksSum;
        calc.calculatedTicksSum = _calculatedTicksSum / numberOfCodeSnippets;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("volatile int arraymb[250000];");
        _builder.newLine();
        _builder.append("int i;");
        _builder.newLine();
        calc.matchingCodeSnippetIdsBuffer = _builder.toString();
        String[] _converted_matchingCodeSnippetsIdsArray = matchingCodeSnippetsIdsArray;
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String codeSumPart) {
                String _matchingCodeSnippetIdsBuffer = calc.matchingCodeSnippetIdsBuffer;
                calc.matchingCodeSnippetIdsBuffer = String.valueOf(_matchingCodeSnippetIdsBuffer) + codeSumPart;
                double _random = Math.random();
                int randomNumber1 = Double.valueOf(_random * 200000.0).intValue();
                double _random_1 = Math.random();
                int randomNumber2 = Double.valueOf(_random_1 * 200000.0).intValue();
                String _matchingCodeSnippetIdsBuffer_1 = calc.matchingCodeSnippetIdsBuffer;
                StringConcatenation _builder = new StringConcatenation();
                if (calc.writesSum > 0 || calc.readsSum > 0) {
                    if (calc.writesSum > 0) {
                        _builder.append("for (i = 0; i < ");
                        _builder.append((Object)calc.writesSum);
                        _builder.append("; i++){");
                        _builder.newLineIfNotEmpty();
                        IntegerRange _upTo = new IntegerRange(0, 9);
                        for (Integer k : _upTo) {
                            _builder.append("\t");
                            _builder.append("arraymb[");
                            double _random_2 = Math.random();
                            int _intValue = Double.valueOf(_random_2 * 5000.0).intValue();
                            _builder.append((Object)_intValue, "\t");
                            _builder.append("] = ");
                            _builder.append((Object)randomNumber1, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                    }
                    if (calc.readsSum > 0) {
                        _builder.append("for (i = 0; i < ");
                        _builder.append((Object)calc.readsSum);
                        _builder.append("; i++){");
                        _builder.newLineIfNotEmpty();
                        IntegerRange _upTo_1 = new IntegerRange(0, 9);
                        for (Integer k_1 : _upTo_1) {
                            _builder.append("\t");
                            _builder.append("arraymb[");
                            double _random_3 = Math.random();
                            int _intValue_1 = Double.valueOf(_random_3 * 5000.0).intValue();
                            _builder.append((Object)_intValue_1, "\t");
                            _builder.append("] == ");
                            _builder.append((Object)randomNumber2, "\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
                _builder.append("ticks(");
                _builder.append((Object)calc.calculatedTicksSum);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                calc.matchingCodeSnippetIdsBuffer = String.valueOf(_matchingCodeSnippetIdsBuffer_1) + _builder;
            }
        };
        ((List)Conversions.doWrapArray((Object)_converted_matchingCodeSnippetsIdsArray)).forEach(_function);
    }

    private static String caseWithOutTicksButWithLabelAccesses(Calculation calc) {
        String _xblockexpression = null;
        double _random = Math.random();
        int randomNumber1 = Double.valueOf(_random * 200000.0).intValue();
        double _random_1 = Math.random();
        int randomNumber2 = Double.valueOf(_random_1 * 200000.0).intValue();
        StringConcatenation _builder = new StringConcatenation();
        if (calc.writesSum > 0 || calc.readsSum > 0) {
            _builder.append("volatile int arraymb[250000];");
            _builder.newLine();
            _builder.append("int i;");
            _builder.newLine();
            if (calc.writesSum > 0) {
                _builder.append("for (i = 0; i < ");
                _builder.append((Object)calc.writesSum);
                _builder.append("; i++){");
                _builder.newLineIfNotEmpty();
                IntegerRange _upTo = new IntegerRange(0, 9);
                for (Integer k : _upTo) {
                    _builder.append("\t");
                    _builder.append("arraymb[");
                    double _random_2 = Math.random();
                    int _intValue = Double.valueOf(_random_2 * 5000.0).intValue();
                    _builder.append((Object)_intValue, "\t");
                    _builder.append("] = ");
                    _builder.append((Object)randomNumber1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("}");
                _builder.newLine();
            }
            if (calc.readsSum > 0) {
                _builder.append("for (i = 0; i < ");
                _builder.append((Object)calc.readsSum);
                _builder.append("; i++){");
                _builder.newLineIfNotEmpty();
                IntegerRange _upTo_1 = new IntegerRange(0, 9);
                for (Integer k_1 : _upTo_1) {
                    _builder.append("\t");
                    _builder.append("arraymb[");
                    double _random_3 = Math.random();
                    int _intValue_1 = Double.valueOf(_random_3 * 5000.0).intValue();
                    _builder.append((Object)_intValue_1, "\t");
                    _builder.append("] == ");
                    _builder.append((Object)randomNumber2, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        _xblockexpression = calc.matchingCodeSnippetIdsBuffer = _builder.toString();
        return _xblockexpression;
    }

    private static String caseWithOnlyTicks(Calculation calc) {
        String _xblockexpression = null;
        double _random = Math.random();
        int randomNumber1 = Double.valueOf(_random * 200000.0).intValue();
        double _random_1 = Math.random();
        int randomNumber2 = Double.valueOf(_random_1 * 200000.0).intValue();
        StringConcatenation _builder = new StringConcatenation();
        if (calc.writesSum > 0 || calc.readsSum > 0) {
            _builder.append("volatile int arraymb[250000];");
            _builder.newLine();
            _builder.append("int i;");
            _builder.newLine();
            if (calc.writesSum > 0) {
                _builder.append("for (i = 0; i < ");
                _builder.append((Object)calc.writesSum);
                _builder.append("; i++){");
                _builder.newLineIfNotEmpty();
                IntegerRange _upTo = new IntegerRange(0, 9);
                for (Integer k : _upTo) {
                    _builder.append("\t");
                    _builder.append("arraymb[");
                    double _random_2 = Math.random();
                    int _intValue = Double.valueOf(_random_2 * 5000.0).intValue();
                    _builder.append((Object)_intValue, "\t");
                    _builder.append("] = ");
                    _builder.append((Object)randomNumber1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("}");
                _builder.newLine();
            }
            if (calc.readsSum > 0) {
                _builder.append("for (i = 0; i < ");
                _builder.append((Object)calc.readsSum);
                _builder.append("; i++){");
                _builder.newLineIfNotEmpty();
                IntegerRange _upTo_1 = new IntegerRange(0, 9);
                for (Integer k_1 : _upTo_1) {
                    _builder.append("\t");
                    _builder.append("arraymb[");
                    double _random_3 = Math.random();
                    int _intValue_1 = Double.valueOf(_random_3 * 5000.0).intValue();
                    _builder.append((Object)_intValue_1, "\t");
                    _builder.append("] == ");
                    _builder.append((Object)randomNumber2, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("ticks(");
        _builder.append((Object)calc.calculatedTicksSum, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _xblockexpression = calc.matchingCodeSnippetIdsBuffer = _builder.toString();
        return _xblockexpression;
    }

    public static class Calculation {
        public int calculatedTicksSum = 0;
        public int readsSum = 0;
        public int writesSum = 0;
        public String matchingCodeSnippetIdsBuffer = "";
        public final HashMap<String, Integer> ticksSumMap = new HashMap();

        public int resetCalculatedTicksSum() {
            this.calculatedTicksSum = 0;
            return 0;
        }
    }
}

