/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.config.CodehookType;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.util.ConfigModelUtils;
import org.eclipse.app4mc.slg.linux.generators.LinuxRunnableGenerator;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseTransformer;

@Singleton
public class LinuxRunnableTransformer
extends LinuxBaseTransformer {
    @Inject
    private Properties properties;
    @Inject
    private CustomObjectsStore customObjsStore;
    private static final String DEFAULT = "default";
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Runnable runnable) {
        SLGTranslationUnit tu;
        ArrayList<Runnable> key = new ArrayList<Runnable>(Arrays.asList(runnable));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(runnable);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, runnable);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(Runnable runnable) {
        if (runnable == null) {
            return new SLGTranslationUnit("UNSPECIFIED RUNNABLE");
        }
        String basePath = "synthetic_gen";
        String moduleName = "runnables";
        String call = String.valueOf(runnable.getName()) + "()";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, Runnable runnable) {
        this.genFiles(tu, runnable);
    }

    private void genFiles(SLGTranslationUnit tu, Runnable runnable) {
        ConfigModel configModel = (ConfigModel)this.customObjsStore.getInstance(ConfigModel.class);
        if (this.isIncFileEmpty(tu)) {
            boolean enableExtCode = Boolean.parseBoolean(this.properties.getProperty("enableExternalCode"));
            if (enableExtCode) {
                for (String hDir : ConfigModelUtils.getHeaderFilesDirectories((ConfigModel)configModel, (CodehookType)CodehookType.RUNNABLE)) {
                    File folder = new File(hDir.trim());
                    String names = ConfigModelUtils.getHeaderFilesIncludeMultiString((File)folder);
                    this.incAppend(tu, names);
                }
            }
            this.incAppend(tu, LinuxRunnableGenerator.snippetIncStart());
        }
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, LinuxRunnableGenerator.snippetSrcStart(configModel));
        }
        this.incAppend(tu, "\n//Runnable " + runnable.getName() + "----\n");
        this.incAppend(tu, "void run_" + runnable.getName() + "(char* coreName);\n");
        LinuxRunnableGenerator.Calculation calc = new LinuxRunnableGenerator.Calculation();
        calc.ticksSumMap.put(DEFAULT, 0);
        if (runnable != null && runnable.getActivityGraph() != null) {
            for (ActivityGraphItem item : runnable.getActivityGraph().getItems()) {
                if (item instanceof Ticks) {
                    Ticks ticks = (Ticks)item;
                    if (ticks.getDefault() != null && ticks.getDefault().getAverage() != null) {
                        calc.ticksSumMap.put(DEFAULT, calc.ticksSumMap.get(DEFAULT) + ticks.getDefault().getAverage().intValue());
                    }
                    Set puDefinitions = ticks.getExtended().keySet();
                    for (ProcessingUnitDefinition puDef : puDefinitions) {
                        if (puDef == null) continue;
                        String puDefName = puDef.getName();
                        if (!calc.ticksSumMap.containsKey(puDefName)) {
                            calc.ticksSumMap.put(puDefName, 0);
                        }
                        calc.ticksSumMap.put(puDefName, calc.ticksSumMap.get(puDefName) + ((IDiscreteValueDeviation)ticks.getExtended().get((Object)puDef)).getAverage().intValue());
                    }
                    continue;
                }
                if (!(item instanceof LabelAccess)) continue;
                LabelAccess la = (LabelAccess)item;
                Float value = Float.valueOf(Float.parseFloat(this.properties.getOrDefault((Object)"labelAccessStatisticValueDefault", "1.0F").toString()));
                LabelAccessStatistic labelStatistic = la.getStatistic();
                if (labelStatistic != null) {
                    NumericStatistic labelStatisticValue = labelStatistic.getValue();
                    if (labelStatisticValue instanceof SingleValueStatistic) {
                        value = Float.valueOf(((SingleValueStatistic)labelStatisticValue).getValue());
                    } else if (labelStatisticValue instanceof MinAvgMaxStatistic) {
                        value = Float.valueOf(((MinAvgMaxStatistic)labelStatisticValue).getAvg());
                    }
                }
                if (la.getAccess() == LabelAccessEnum.READ) {
                    calc.readsSum += value.intValue();
                    continue;
                }
                if (la.getAccess() != LabelAccessEnum.WRITE) continue;
                calc.writesSum += value.intValue();
            }
        }
        boolean useExperimental = Boolean.parseBoolean(this.properties.getProperty("experimentalCodeSnippetMatching"));
        boolean enableExtCode = Boolean.parseBoolean(this.properties.getProperty("enableExternalCode"));
        String codeString = LinuxRunnableGenerator.syntheticLoad(runnable, useExperimental, this.properties, enableExtCode);
        this.srcAppend(tu, LinuxRunnableGenerator.snippetSrcBody(runnable, codeString, enableExtCode));
    }
}

